/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.model.type;

import java.util.List;
import org.ametys.core.model.type.AbstractElementType;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractDoubleElementType
extends AbstractElementType<Double> {
    public static final String TYPE_ID = "double";

    @Override
    public Double castValue(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return Double.valueOf(value);
    }

    @Override
    public Object fromJSONForClient(Object json) {
        if (json == null) {
            return null;
        }
        if (json instanceof Number) {
            return ((Number)json).doubleValue();
        }
        if (json instanceof List) {
            List jsonList = (List)json;
            Double[] result = new Double[jsonList.size()];
            for (int i = 0; i < jsonList.size(); ++i) {
                Object singleJSON = jsonList.get(i);
                if (!(singleJSON instanceof Number)) {
                    throw new IllegalArgumentException("Try to convert the non Double JSON object '" + json + "' into a Double");
                }
                result[i] = ((Number)singleJSON).doubleValue();
            }
            return result;
        }
        throw new IllegalArgumentException("Try to convert the non Double JSON object '" + json + "' into a Double");
    }

    @Override
    public boolean isSimple() {
        return true;
    }
}

