/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.model.type;

import java.util.ArrayList;
import java.util.List;
import org.ametys.core.model.type.AbstractElementType;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractStringElementType
extends AbstractElementType<String> {
    public static final String TYPE_ID = "string";

    @Override
    public String castValue(String value) {
        return value;
    }

    @Override
    public String toString(String value) {
        return value;
    }

    @Override
    public Object fromJSONForClient(Object json) {
        if (json == null || json instanceof String) {
            return json;
        }
        if (json instanceof List) {
            List jsonList = (List)json;
            return jsonList.toArray(new String[jsonList.size()]);
        }
        throw new IllegalArgumentException("Try to convert the non String JSON object '" + json + "' into a String");
    }

    protected Object passwordValueToJSONForClient(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            return !StringUtils.isEmpty((CharSequence)stringValue) ? "PASSWORD" : stringValue;
        }
        if (value instanceof String[]) {
            ArrayList<String> values = new ArrayList<String>();
            for (String singleValue : (String[])value) {
                values.add(!StringUtils.isEmpty((CharSequence)singleValue) ? "PASSWORD" : singleValue);
            }
            return values;
        }
        throw new IllegalArgumentException("Try to convert the non String value '" + value + "' to JSON");
    }

    @Override
    public boolean isSimple() {
        return true;
    }
}

