/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.script;

import java.sql.Connection;
import java.util.HashSet;
import java.util.Set;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.datasource.SQLDataSourceManager;
import org.ametys.core.script.SQLScriptHelper;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.Init;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.SourceResolver;

public class SqlTablesInit
extends AbstractLogEnabled
implements Init,
Serviceable,
Configurable,
PluginAware {
    protected String _pluginName;
    protected String _dataSourceId;
    protected Set<InitScript> _scripts;
    protected SQLDataSourceManager _sqlDataSourceManager;
    protected SourceResolver _sourceResolver;

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._sqlDataSourceManager = (SQLDataSourceManager)manager.lookup(SQLDataSourceManager.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] scripts;
        Configuration dataSourceConf = configuration.getChild("datasource", false);
        if (dataSourceConf == null) {
            throw new ConfigurationException("The 'datasource' configuration node must be defined.", dataSourceConf);
        }
        String dataSourceConfParam = dataSourceConf.getValue();
        String dataSourceConfType = dataSourceConf.getAttribute("type", "config");
        this._dataSourceId = StringUtils.equals((CharSequence)dataSourceConfType, (CharSequence)"config") ? (String)Config.getInstance().getValue(dataSourceConfParam) : dataSourceConfParam;
        this._scripts = new HashSet<InitScript>();
        for (Configuration scriptConf : scripts = configuration.getChildren("script")) {
            String pluginName = scriptConf.getAttribute("plugin", this._pluginName);
            String testTable = scriptConf.getAttribute("testTable");
            if (StringUtils.isBlank((CharSequence)testTable)) {
                throw new ConfigurationException("The test table attribute cannot be blank.");
            }
            String fileName = scriptConf.getValue();
            if (StringUtils.isBlank((CharSequence)fileName)) {
                throw new ConfigurationException("The SQL file name cannot be blank.");
            }
            this._scripts.add(new InitScript(pluginName, fileName, testTable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws Exception {
        try {
            Connection connection = null;
            try {
                connection = ConnectionHelper.getConnection(this._dataSourceId);
                String scriptFolder = ConnectionHelper.getDatabaseType(connection);
                for (InitScript initScript : this._scripts) {
                    SQLScriptHelper.createTableIfNotExists(connection, initScript._testTable, "plugin:" + initScript._pluginName + "://scripts/" + scriptFolder + "/" + initScript._fileName, this._sourceResolver);
                }
            }
            finally {
                ConnectionHelper.cleanup(connection);
            }
        }
        catch (Exception e) {
            String errorMsg = String.format("Error during SQL tables initialization for data source id: '%s'.", StringUtils.defaultString((String)this._dataSourceId));
            this.getLogger().error(errorMsg, (Throwable)e);
        }
    }

    private static class InitScript {
        final String _pluginName;
        final String _fileName;
        final String _testTable;

        public InitScript(String pluginNameArg, String fileNameArg, String testTableArg) {
            this._pluginName = pluginNameArg;
            this._fileName = fileNameArg;
            this._testTable = testTableArg;
        }
    }
}

