/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.AbstractClientSideExtensionPoint;
import org.ametys.core.ui.ClientSideElement;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSideElementDependenciesManager {
    protected Logger _logger = LoggerFactory.getLogger(ClientSideElementDependenciesManager.class);
    private Map<String, List<String>> _dependencies = new HashMap<String, List<String>>();
    private ServiceManager _manager;

    public ClientSideElementDependenciesManager(ServiceManager manager) {
        this._manager = manager;
    }

    public void register(String extensionPoint, String extensionId) {
        List<String> extensions;
        if (!this._dependencies.containsKey(extensionPoint)) {
            this._dependencies.put(extensionPoint, new ArrayList());
        }
        if (!(extensions = this._dependencies.get(extensionPoint)).contains(extensionId)) {
            extensions.add(extensionId);
        }
    }

    public void register(ClientSideElement element) {
        Map<String, List<String>> dependencies = element.getDependencies();
        for (Map.Entry<String, List<String>> entry : dependencies.entrySet()) {
            String extensionPoint = entry.getKey();
            for (String extensionId : entry.getValue()) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Register dependency : The extension '" + element.getId() + "' depends on '" + extensionId + "' of extension point '" + extensionPoint + "')");
                }
                this.register(extensionPoint, extensionId);
            }
        }
    }

    public Map<String, List<ClientSideElement>> computeDependencies() throws ServiceException {
        HashMap<String, List<ClientSideElement>> computedDependencies = new HashMap<String, List<ClientSideElement>>();
        this.computeDependencies(computedDependencies, this._dependencies, new ArrayList<ClientSideElement>());
        return computedDependencies;
    }

    private void computeDependencies(Map<String, List<ClientSideElement>> computedDependencies, Map<String, List<String>> dependenciesToProcess, List<ClientSideElement> knownElements) throws ServiceException {
        for (Map.Entry<String, List<String>> dependencyToProcess : dependenciesToProcess.entrySet()) {
            String extensionPointId = dependencyToProcess.getKey();
            AbstractClientSideExtensionPoint extensionPoint = (AbstractClientSideExtensionPoint)this._manager.lookup(extensionPointId);
            if (!computedDependencies.containsKey(extensionPointId)) {
                computedDependencies.put(extensionPointId, new ArrayList());
            }
            for (String extensionIdToProcess : dependencyToProcess.getValue()) {
                for (ClientSideElement extension : extensionPoint.findDependency(extensionIdToProcess)) {
                    if (extension == null || knownElements.contains(extension)) continue;
                    knownElements.add(extension);
                    Map<String, List<String>> dependencies = extension.getDependencies();
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug("Computing dependencies : For extension point '" + extensionPointId + "', the extension : '" + extensionIdToProcess + "' requires the following dependencies : " + dependencies.toString());
                    }
                    this.computeDependencies(computedDependencies, dependencies, knownElements);
                    computedDependencies.get(extensionPointId).add(extension);
                }
            }
        }
    }
}

