/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.ribbonconfiguration;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.ametys.core.ui.RibbonControlsManager;
import org.ametys.core.ui.RibbonManager;
import org.ametys.core.ui.SimpleMenu;
import org.ametys.core.ui.ribbonconfiguration.Element;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.slf4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ControlRef
implements Element {
    protected String _id;
    protected int _colspan;
    protected Logger _controlLogger;

    public ControlRef(Configuration controlConfiguration, RibbonManager ribbonManager, Logger logger) throws ConfigurationException {
        String refId = controlConfiguration.getAttribute("ref-id", null);
        if (refId == null && controlConfiguration.getChildren().length == 0) {
            this._initialize(controlConfiguration.getAttribute("id"), controlConfiguration.getAttributeAsInteger("colspan", 1), logger);
        } else {
            String id = controlConfiguration.getAttribute("id", UUID.randomUUID().toString());
            DefaultConfiguration defaultConfig = new DefaultConfiguration(controlConfiguration);
            String classname = controlConfiguration.getAttribute("class", null);
            if (classname == null) {
                if (refId != null) {
                    defaultConfig.setAttribute("point", controlConfiguration.getAttribute("point", RibbonControlsManager.ROLE));
                } else {
                    classname = SimpleMenu.class.getName();
                    defaultConfig.setAttribute("class", classname);
                }
            }
            ribbonManager.addExtension(id, "core-ui", null, (Configuration)defaultConfig);
            this._initialize(id, controlConfiguration.getAttributeAsInteger("colspan", 1), logger);
        }
    }

    public ControlRef(String id, int colspan, Logger logger) {
        this._initialize(id, colspan, logger);
    }

    private void _initialize(String id, int colspan, Logger logger) {
        this._controlLogger = logger;
        this._id = id;
        if (this._controlLogger.isDebugEnabled()) {
            this._controlLogger.debug("Control id is " + this._id);
        }
        this._colspan = colspan;
        if (this._controlLogger.isDebugEnabled()) {
            this._controlLogger.debug("Control colspan is " + this._colspan);
        }
    }

    public String getId() {
        return this._id;
    }

    @Override
    public int getColumns() {
        return this._colspan;
    }

    @Override
    public void setColumns(int size) {
        this._colspan = size;
    }

    @Override
    public List<Element> getChildren() {
        return new ArrayList<Element>();
    }

    @Override
    public void toSAX(ContentHandler handler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", this._id);
        attrs.addCDATAAttribute("colspan", Integer.toString(this._colspan));
        XMLUtils.createElement((ContentHandler)handler, (String)"control", (Attributes)attrs);
    }

    @Override
    public boolean isSame(Element element) {
        if (!(element instanceof ControlRef)) {
            return false;
        }
        ControlRef controlRef = (ControlRef)element;
        return controlRef._id == this._id && controlRef._colspan == this._colspan;
    }

    public String toString() {
        return super.toString() + "[" + this._id + "]";
    }
}

