/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.widgets.richtext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.widgets.richtext.RichTextConfiguration;
import org.ametys.core.ui.widgets.richtext.RichTextConfigurationAttribute;
import org.ametys.core.ui.widgets.richtext.RichTextConfigurationStyle;
import org.ametys.core.ui.widgets.richtext.RichTextConfigurationStyleGroup;
import org.ametys.core.ui.widgets.richtext.RichTextConfigurationTag;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;

public class RichTextConfigurationExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<RichTextConfiguration> {
    public static final String ROLE = RichTextConfigurationExtensionPoint.class.getName();

    @Callable
    public Map<String, Object> toJSON(Map<String, Object> contextualParameters) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        for (String extensionId : this.getExtensionsIds()) {
            this._addExtensionToJSON(contextualParameters, json, (RichTextConfiguration)this.getExtension(extensionId));
        }
        return json;
    }

    private void _addExtensionToJSON(Map<String, Object> contextualParameters, Map<String, Object> json, RichTextConfiguration extension) {
        Set<String> categories = extension.getCategories();
        for (String category : categories) {
            Map jsonCategory;
            if (!json.containsKey(category)) {
                jsonCategory = new HashMap();
                json.put(category, jsonCategory);
                jsonCategory.put("tags", new HashMap());
                jsonCategory.put("styles", new HashMap());
                jsonCategory.put("css", new HashSet());
                jsonCategory.put("validators", new ArrayList());
                jsonCategory.put("convertors", new ArrayList());
            }
            jsonCategory = (Map)json.get(category);
            this._addTagsToJSON((Map)jsonCategory.get("tags"), extension.getHandledTags(category, contextualParameters));
            this._addStylesToJSON((Map)jsonCategory.get("styles"), extension.getAvailableStyles(category, contextualParameters));
            this._addFilesToJSON((Set)jsonCategory.get("css"), extension.getCSSFiles(category, contextualParameters));
            this._addClientSideElementToJSON((List)jsonCategory.get("validators"), extension.getValidators(category, contextualParameters));
            this._addClientSideElementToJSON((List)jsonCategory.get("convertors"), extension.getConvertors(category, contextualParameters));
        }
    }

    private void _addTagsToJSON(Map<String, Object> object, Collection<RichTextConfigurationTag> handledTags) {
        if (handledTags != null) {
            for (RichTextConfigurationTag handledTag : handledTags) {
                Map<String, HashMap<String, Object>> jsonTag;
                if (!object.containsKey(handledTag.getTag())) {
                    jsonTag = new HashMap<String, RichTextConfigurationTag.EMPTY_TAG>();
                    jsonTag.put("empty", (HashMap<String, Object>)((Object)RichTextConfigurationTag.EMPTY_TAG.CLOSE));
                    jsonTag.put("synonyms", (HashMap<String, Object>)((Object)new HashSet()));
                    jsonTag.put("attributes", new HashMap());
                    object.put(handledTag.getTag(), jsonTag);
                }
                jsonTag = (Map)object.get(handledTag.getTag());
                jsonTag.put("empty", (HashMap<String, Object>)((Object)(handledTag.onEmptyTag().compareTo((RichTextConfigurationTag.EMPTY_TAG)((Object)jsonTag.get("empty"))) < 0 ? handledTag.onEmptyTag() : (RichTextConfigurationTag.EMPTY_TAG)((Object)jsonTag.get("empty")))));
                ((Set)jsonTag.get("synonyms")).addAll(handledTag.getSynonyms());
                Map attributes = (Map)jsonTag.get("attributes");
                for (RichTextConfigurationAttribute attribute : handledTag.getAttributes()) {
                    Map jsonAttribute;
                    boolean classAttribute = "class".equals(attribute.getName());
                    if (!attributes.containsKey(attribute.getName())) {
                        jsonAttribute = new HashMap<String, Object>();
                        jsonAttribute.put("default-value", null);
                        jsonAttribute.put("values", new ArrayList());
                        if (classAttribute) {
                            jsonAttribute.put("technical-values", new ArrayList());
                        }
                        attributes.put(attribute.getName(), jsonAttribute);
                    }
                    jsonAttribute = (Map)attributes.get(attribute.getName());
                    jsonAttribute.put("default-value", attribute.getDefaultValue());
                    ((List)jsonAttribute.get("values")).addAll(attribute.getAuthorizedValues());
                    if (!classAttribute) continue;
                    ((List)jsonAttribute.get("technical-values")).addAll(attribute.getTechnicalValues());
                }
            }
        }
    }

    private void _addStylesToJSON(Map<String, Map<String, List<Map<String, Object>>>> object, Map<String, Map<RichTextConfigurationStyleGroup, List<RichTextConfigurationStyle>>> availableStyles) {
        if (availableStyles != null) {
            for (Map.Entry<String, Map<RichTextConfigurationStyleGroup, List<RichTextConfigurationStyle>>> entry : availableStyles.entrySet()) {
                Object jsonStylesGroups;
                if (!object.containsKey(entry.getKey())) {
                    jsonStylesGroups = new HashMap();
                    jsonStylesGroups.put("groups", new ArrayList());
                    object.put(entry.getKey(), (Map<String, List<Map<String, Object>>>)jsonStylesGroups);
                }
                jsonStylesGroups = object.get(entry.getKey()).get("groups");
                for (Map.Entry<RichTextConfigurationStyleGroup, List<RichTextConfigurationStyle>> entry2 : entry.getValue().entrySet()) {
                    ArrayList jsonStyles = new ArrayList();
                    for (RichTextConfigurationStyle richTextConfigurationStyle : entry2.getValue()) {
                        HashMap<String, Object> styleAsJSON = new HashMap<String, Object>();
                        jsonStyles.add(styleAsJSON);
                        styleAsJSON.put("tagname", richTextConfigurationStyle.getTagName());
                        styleAsJSON.put("cssclass", richTextConfigurationStyle.getClassName());
                        styleAsJSON.put("label", richTextConfigurationStyle.getButtonLabel());
                        styleAsJSON.put("description", richTextConfigurationStyle.getButtonDescription());
                        styleAsJSON.put("buttonCSSClass", richTextConfigurationStyle.getButtonCSSClass());
                        styleAsJSON.put("buttonSmallIcon", richTextConfigurationStyle.getButtonSmallIcon());
                        styleAsJSON.put("buttonMediumIcon", richTextConfigurationStyle.getButtonMediumIcon());
                        styleAsJSON.put("buttonLargeIcon", richTextConfigurationStyle.getButtonLargeIcon());
                    }
                    HashMap<String, Object> group = new HashMap<String, Object>();
                    group.put("label", entry2.getKey().getLabel());
                    group.put("priority", entry2.getKey().getPriority());
                    group.put("values", jsonStyles);
                    jsonStylesGroups.add(group);
                }
            }
        }
    }

    private void _addFilesToJSON(Set<Map<String, Object>> object, List<ClientSideElement.ScriptFile> cssFiles) {
        if (cssFiles != null) {
            for (ClientSideElement.ScriptFile file : cssFiles) {
                object.add(this._scriptFileToJson(file));
            }
        }
    }

    private void _addClientSideElementToJSON(List<Object> list, Set<ClientSideElement> clientSideElements) {
        if (clientSideElements != null) {
            for (ClientSideElement clientSideElementn : clientSideElements) {
                List<ClientSideElement.Script> scripts = clientSideElementn.getScripts(Collections.EMPTY_MAP);
                for (ClientSideElement.Script script : scripts) {
                    HashMap jsonClientSideElement = new HashMap();
                    HashMap<String, Object> jsonClass = new HashMap<String, Object>();
                    jsonClass.put("name", script.getScriptClassname());
                    jsonClass.put("parameters", script.getParameters());
                    jsonClientSideElement.put("class", jsonClass);
                    list.add(jsonClientSideElement);
                }
            }
        }
    }

    private Map<String, Object> _scriptFileToJson(ClientSideElement.ScriptFile scriptFile) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (scriptFile.isLangSpecific()) {
            json.put("language", true);
            json.put("default", scriptFile.getDefaultLang());
            json.put("url", scriptFile.getLangPaths());
        } else {
            json.put("language", false);
            json.put("url", scriptFile.getPath());
            json.put("rtl", scriptFile.getRtlMode());
        }
        return json;
    }
}

