/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user.population;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.authentication.CredentialProviderFactory;
import org.ametys.core.authentication.CredentialProviderModel;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.script.SQLScriptHelper;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.InvalidModificationException;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.directory.ModifiableUserDirectory;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.directory.UserDirectoryFactory;
import org.ametys.core.user.directory.UserDirectoryModel;
import org.ametys.core.user.population.PopulationConsumerExtensionPoint;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.StringUtils;
import org.ametys.plugins.core.impl.user.directory.StaticUserDirectory;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.checker.ItemCheckerDescriptor;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.model.type.xml.XMLElementType;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UserPopulationDAO
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable,
Disposable {
    public static final String ROLE = UserPopulationDAO.class.getName();
    public static final String ADMIN_POPULATION_ID = "admin_population";
    public static final String SYSTEM_USER_LOGIN = "system-user";
    public static final UserIdentity SYSTEM_USER_IDENTITY = new UserIdentity("system-user", "admin_population");
    private static final String __ADMIN_TABLENAME = "AdminUsers";
    private static File __USER_POPULATIONS_FILE;
    private static final String __ID_REGEX = "^[a-z][a-z0-9_-]*";
    private long _lastFileReading;
    private Map<String, UserPopulation> _userPopulations;
    private Set<String> _misconfiguredUserPopulations;
    private Set<String> _ignoredPopulations;
    private UserPopulation _adminUserPopulation;
    private UserDirectoryFactory _userDirectoryFactory;
    private CredentialProviderFactory _credentialProviderFactory;
    private PopulationConsumerExtensionPoint _populationConsumerEP;
    private ObservationManager _observationManager;
    private CurrentUserProvider _currentUserProvider;
    private I18nUtils _i18nutils;

    public void initialize() {
        __USER_POPULATIONS_FILE = new File(AmetysHomeHelper.getAmetysHome(), "config" + File.separator + "user-populations.xml");
        this._userPopulations = new LinkedHashMap<String, UserPopulation>();
        this._misconfiguredUserPopulations = new HashSet<String>();
        this._ignoredPopulations = new HashSet<String>();
        this._lastFileReading = 0L;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._userDirectoryFactory = (UserDirectoryFactory)manager.lookup(UserDirectoryFactory.ROLE);
        this._credentialProviderFactory = (CredentialProviderFactory)manager.lookup(CredentialProviderFactory.ROLE);
        this._populationConsumerEP = (PopulationConsumerExtensionPoint)manager.lookup(PopulationConsumerExtensionPoint.ROLE);
        try {
            this._observationManager = (ObservationManager)((Object)manager.lookup(ObservationManager.ROLE));
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._i18nutils = (I18nUtils)((Object)manager.lookup(I18nUtils.ROLE));
    }

    public List<Object> getUserPopulationsAsJson(boolean withAdmin) {
        return this.getUserPopulations(withAdmin).stream().map(this::getUserPopulationAsJson).collect(Collectors.toList());
    }

    public Map<String, Object> getUserPopulationAsJson(UserPopulation userPopulation) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("id", userPopulation.getId());
        result.put("label", userPopulation.getLabel());
        result.put("enabled", userPopulation.isEnabled());
        result.put("valid", this.isValid(userPopulation.getId()));
        result.put("isInUse", this._populationConsumerEP.isInUse(userPopulation.getId()));
        ArrayList userDirectories = new ArrayList();
        for (UserDirectory ud : userPopulation.getUserDirectories()) {
            String udModelId = ud.getUserDirectoryModelId();
            UserDirectoryModel udModel = this._userDirectoryFactory.getExtension(udModelId);
            HashMap<String, Object> directory = new HashMap<String, Object>();
            directory.put("id", ud.getId());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ud.getLabel())) {
                directory.put("label", this._i18nutils.translate(udModel.getLabel()) + " (" + ud.getLabel() + ")");
            } else {
                directory.put("label", udModel.getLabel());
            }
            directory.put("modifiable", ud instanceof ModifiableUserDirectory);
            userDirectories.add(directory);
        }
        result.put("userDirectories", userDirectories);
        ArrayList credentialProviders = new ArrayList();
        for (CredentialProvider cp : userPopulation.getCredentialProviders()) {
            String cpModelId = cp.getCredentialProviderModelId();
            CredentialProviderModel cpModel = this._credentialProviderFactory.getExtension(cpModelId);
            HashMap<String, Object> credentialProvider = new HashMap<String, Object>();
            credentialProvider.put("id", cp.getId());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)cp.getLabel())) {
                credentialProvider.put("label", this._i18nutils.translate(cpModel.getLabel()) + " (" + cp.getLabel() + ")");
            } else {
                credentialProvider.put("label", cpModel.getLabel());
            }
            credentialProviders.add(credentialProvider);
        }
        result.put("credentialProviders", credentialProviders);
        return result;
    }

    public List<UserPopulation> getUserPopulations(boolean includeAdminPopulation) {
        ArrayList<UserPopulation> result = new ArrayList<UserPopulation>();
        if (includeAdminPopulation) {
            result.add(this.getAdminPopulation());
        }
        if (PluginsManager.Status.OK.equals((Object)PluginsManager.getInstance().getStatus())) {
            this._readPopulations(false);
            result.addAll(this._userPopulations.values());
        }
        return result;
    }

    public List<UserPopulation> getEnabledUserPopulations(boolean withAdmin) {
        return this.getUserPopulations(withAdmin).stream().filter(UserPopulation::isEnabled).collect(Collectors.toList());
    }

    public UserPopulation getUserPopulation(String id) {
        if (ADMIN_POPULATION_ID.equals(id)) {
            return this.getAdminPopulation();
        }
        this._readPopulations(false);
        return this._userPopulations.get(id);
    }

    @Callable
    public List<String> getUserPopulationsIds() {
        this._readPopulations(false);
        return new ArrayList<String>(this._userPopulations.keySet());
    }

    public Set<String> getIgnoredPopulations() {
        this._readPopulations(false);
        return this._ignoredPopulations;
    }

    public Set<String> getMisconfiguredPopulations() {
        this._readPopulations(false);
        return this._misconfiguredUserPopulations;
    }

    public File getConfigurationFile() {
        return __USER_POPULATIONS_FILE;
    }

    @Callable
    public Map<String, Object> getEditionConfiguration() throws Exception {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        ArrayList userDirectoryModels = new ArrayList();
        for (String extensionId : this._userDirectoryFactory.getExtensionsIds()) {
            UserDirectoryModel udModel = this._userDirectoryFactory.getExtension(extensionId);
            if (udModel == null) {
                throw new IllegalStateException("The user population configuration refers to an unexisting extension for the user directory '" + extensionId + "'");
            }
            LinkedHashMap<String, Object> udMap = new LinkedHashMap<String, Object>();
            udMap.put("id", extensionId);
            udMap.put("label", udModel.getLabel());
            udMap.put("description", udModel.getDescription());
            LinkedHashMap<String, Map<String, Object>> params = new LinkedHashMap<String, Map<String, Object>>();
            for (String string : udModel.getParameters().keySet()) {
                params.put(extensionId + "$" + string, udModel.getParameters().get(string).toJSON());
            }
            udMap.put("parameters", params);
            LinkedHashMap<String, Map<String, Object>> paramCheckers = new LinkedHashMap<String, Map<String, Object>>();
            for (String paramCheckerId : udModel.getParameterCheckers().keySet()) {
                ItemCheckerDescriptor paramChecker = udModel.getParameterCheckers().get(paramCheckerId);
                paramCheckers.put(extensionId + "$" + paramCheckerId, paramChecker.toJSON());
            }
            udMap.put("parameterCheckers", paramCheckers);
            userDirectoryModels.add(udMap);
        }
        result.put("userDirectoryModels", userDirectoryModels);
        ArrayList credentialProviderModels = new ArrayList();
        for (String extensionId : this._credentialProviderFactory.getExtensionsIds()) {
            CredentialProviderModel cpModel = this._credentialProviderFactory.getExtension(extensionId);
            if (cpModel == null) {
                throw new IllegalStateException("The user population configuration refers to an unexisting extension for the credential provider '" + extensionId + "'");
            }
            LinkedHashMap<String, Object> cpMap = new LinkedHashMap<String, Object>();
            cpMap.put("id", extensionId);
            cpMap.put("label", cpModel.getLabel());
            cpMap.put("description", cpModel.getDescription());
            LinkedHashMap<String, Map<String, Object>> params = new LinkedHashMap<String, Map<String, Object>>();
            for (String paramId : cpModel.getParameters().keySet()) {
                params.put(extensionId + "$" + paramId, cpModel.getParameters().get(paramId).toJSON());
            }
            cpMap.put("parameters", params);
            LinkedHashMap<String, Map<String, Object>> linkedHashMap = new LinkedHashMap<String, Map<String, Object>>();
            for (String paramCheckerId : cpModel.getParameterCheckers().keySet()) {
                ItemCheckerDescriptor paramChecker = cpModel.getParameterCheckers().get(paramCheckerId);
                linkedHashMap.put(extensionId + "$" + paramCheckerId, paramChecker.toJSON());
            }
            cpMap.put("parameterCheckers", linkedHashMap);
            credentialProviderModels.add(cpMap);
        }
        result.put("credentialProviderModels", credentialProviderModels);
        return result;
    }

    @Callable
    public Map<String, Object> getPopulationParameterValues(String id) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this._readPopulations(false);
        UserPopulation up = this._userPopulations.get(id);
        if (up == null) {
            this.getLogger().error("The UserPopulation of id '{}' does not exists.", (Object)id);
            result.put("error", "unknown");
            return result;
        }
        result.put("label", up.getLabel());
        result.put("id", up.getId());
        ArrayList userDirectories = new ArrayList();
        for (UserDirectory ud : up.getUserDirectories()) {
            HashMap<String, Object> ud2json = new HashMap<String, Object>();
            String udModelId = ud.getUserDirectoryModelId();
            UserDirectoryModel model = this._userDirectoryFactory.getExtension(udModelId);
            if (model == null) {
                throw new IllegalStateException("The user population configuration refers to an unexisting extension for the user directory '" + udModelId + "'");
            }
            ud2json.put("id", ud.getId());
            ud2json.put("udModelId", udModelId);
            ud2json.put("label", ud.getLabel());
            HashMap<String, Object> params = new HashMap<String, Object>();
            for (String key : ud.getParameterValues().keySet()) {
                ElementDefinition parameter = model.getParameters().get(key);
                params.put(udModelId + "$" + key, "password".equals(parameter.getType().getId()) ? "PASSWORD" : ud.getParameterValues().get(key));
            }
            ud2json.put("params", params);
            userDirectories.add(ud2json);
        }
        result.put("userDirectories", userDirectories);
        ArrayList credentialProviders = new ArrayList();
        for (CredentialProvider cp : up.getCredentialProviders()) {
            HashMap<String, Object> cp2json = new HashMap<String, Object>();
            String cpModelId = cp.getCredentialProviderModelId();
            CredentialProviderModel model = this._credentialProviderFactory.getExtension(cpModelId);
            if (model == null) {
                throw new IllegalStateException("The user population configuration refers to an unexisting extension for the credential provider '" + cpModelId + "'");
            }
            cp2json.put("id", cp.getId());
            cp2json.put("cpModelId", cpModelId);
            cp2json.put("label", cp.getLabel());
            HashMap<String, Object> params = new HashMap<String, Object>();
            for (String key : cp.getParameterValues().keySet()) {
                ElementDefinition parameter = model.getParameters().get(key);
                params.put(cpModelId + "$" + key, "password".equals(parameter.getType().getId()) ? "PASSWORD" : cp.getParameterValues().get(key));
            }
            cp2json.put("params", params);
            credentialProviders.add(cp2json);
        }
        result.put("credentialProviders", credentialProviders);
        return result;
    }

    public synchronized UserPopulation getAdminPopulation() {
        if (this._adminUserPopulation != null) {
            return this._adminUserPopulation;
        }
        this._adminUserPopulation = new UserPopulation();
        this._adminUserPopulation.setId(ADMIN_POPULATION_ID);
        HashMap<String, String> userDirectory1 = new HashMap<String, String>();
        userDirectory1.put("udModelId", "org.ametys.plugins.core.user.directory.Static");
        userDirectory1.put("id", "static");
        userDirectory1.put("org.ametys.plugins.core.user.directory.Static$runtime.users.static.users", "system-user:System:User:");
        HashMap<String, String> userDirectory2 = new HashMap<String, String>();
        userDirectory2.put("udModelId", "org.ametys.plugins.core.user.directory.Jdbc");
        userDirectory2.put("org.ametys.plugins.core.user.directory.Jdbc$runtime.users.jdbc.datasource", "SQL-ametys-internal");
        userDirectory2.put("org.ametys.plugins.core.user.directory.Jdbc$runtime.users.jdbc.table", __ADMIN_TABLENAME);
        HashMap<String, String> credentialProvider = new HashMap<String, String>();
        String cpModelId = "org.ametys.core.authentication.FormBased";
        credentialProvider.put("cpModelId", cpModelId);
        credentialProvider.put(cpModelId + "$runtime.authentication.form.cookies", "false");
        credentialProvider.put(cpModelId + "$runtime.authentication.form.captcha", "true");
        credentialProvider.put(cpModelId + "$runtime.authentication.form.login-by-email", "false");
        credentialProvider.put(cpModelId + "$runtime.authentication.form.security.storage", "SQL-ametys-internal");
        boolean wasExisting = false;
        try (Connection connection = ConnectionHelper.getInternalSQLDataSourceConnection();){
            wasExisting = SQLScriptHelper.tableExists(connection, __ADMIN_TABLENAME);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot test if AdminUsers table exists in internal database", e);
        }
        this._fillUserPopulation(this._adminUserPopulation, new I18nizableText("plugin.core", "PLUGINS_CORE_USER_POPULATION_ADMIN_LABEL"), Arrays.asList(userDirectory1, userDirectory2), Collections.singletonList(credentialProvider));
        ((StaticUserDirectory)this._adminUserPopulation.getUserDirectory("static")).setGrantAllCredentials(false);
        if (!wasExisting) {
            HashMap<String, String> adminUserInformations = new HashMap<String, String>();
            adminUserInformations.put("login", "admin");
            adminUserInformations.put("password", "admin");
            adminUserInformations.put("firstname", "User");
            adminUserInformations.put("lastname", "Administrator");
            adminUserInformations.put("email", "");
            ModifiableUserDirectory adminJdbcUserDirectoy = (ModifiableUserDirectory)this._adminUserPopulation.getUserDirectories().get(1);
            try {
                adminJdbcUserDirectoy.add(adminUserInformations);
            }
            catch (InvalidModificationException e) {
                throw new RuntimeException("Cannot create the 'admin' user", e);
            }
        }
        return this._adminUserPopulation;
    }

    @Callable
    public Map<String, Object> add(String id, String label, List<Map<String, String>> userDirectories, List<Map<String, String>> credentialProviders) {
        this._readPopulations(false);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (!this._isCorrectId(id)) {
            return null;
        }
        UserPopulation up = new UserPopulation();
        up.setId(id);
        this._fillUserPopulation(up, new I18nizableText(label), userDirectories, credentialProviders);
        this._userPopulations.put(id, up);
        if (this._writePopulations()) {
            this.getLogger().error("An error occured when writing the configuration file which contains the user populations.", (Object)id);
            result.put("error", "server");
            return result;
        }
        if (this._observationManager != null) {
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("userpopulation-id", id);
            this._observationManager.notify(new Event("userpopulation.added", this._currentUserProvider.getUser(), eventParams));
        }
        result.put("id", id);
        return result;
    }

    private boolean _isCorrectId(String id) {
        if (this._userPopulations.get(id) != null || ADMIN_POPULATION_ID.equals(id)) {
            this.getLogger().error("The id '{}' is already used for a population.", (Object)id);
            return false;
        }
        if (!Pattern.matches(__ID_REGEX, id)) {
            this.getLogger().error("The id '{}' is not a correct id for a user population.", (Object)id);
            return false;
        }
        return true;
    }

    @Callable
    public Map<String, Object> edit(String id, String label, List<Map<String, String>> userDirectories, List<Map<String, String>> credentialProviders) {
        this._readPopulations(false);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        UserPopulation up = this._userPopulations.get(id);
        if (up == null) {
            this.getLogger().error("The UserPopulation with id '{}' does not exist, it cannot be edited.", (Object)id);
            result.put("error", "unknown");
            return result;
        }
        up.dispose();
        this._fillUserPopulation(up, new I18nizableText(label), userDirectories, credentialProviders);
        if (this._writePopulations()) {
            this.getLogger().error("An error occured when writing the configuration file which contains the user populations.", (Object)id);
            result.put("error", "server");
            return result;
        }
        if (this._observationManager != null) {
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("userpopulation-id", id);
            this._observationManager.notify(new Event("userpopulation.updated", this._currentUserProvider.getUser(), eventParams));
        }
        result.put("id", id);
        return result;
    }

    private void _fillUserPopulation(UserPopulation up, I18nizableText label, List<Map<String, String>> userDirectories, List<Map<String, String>> credentialProviders) {
        up.setLabel(label);
        ArrayList<UserDirectory> uds = new ArrayList<UserDirectory>();
        for (Map<String, String> userDirectoryParameters : userDirectories) {
            String id = userDirectoryParameters.remove("id");
            String modelId = userDirectoryParameters.remove("udModelId");
            String additionnalLabel = userDirectoryParameters.remove("label");
            Map<String, Object> typedParamValues = this._getTypedUDParameters(userDirectoryParameters, modelId);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)id)) {
                id = StringUtils.generateKey();
            } else {
                this._keepExistingUserDirectoryPassword(up, modelId, typedParamValues, id);
            }
            uds.add(this._userDirectoryFactory.createUserDirectory(id, modelId, typedParamValues, up.getId(), additionnalLabel));
        }
        up.setUserDirectories(uds);
        ArrayList<CredentialProvider> cps = new ArrayList<CredentialProvider>();
        for (Map<String, String> credentialProviderParameters : credentialProviders) {
            CredentialProvider credentialProvider;
            String id = credentialProviderParameters.remove("id");
            String modelId = credentialProviderParameters.remove("cpModelId");
            String additionnalLabel = credentialProviderParameters.remove("label");
            Map<String, Object> typedParamValues = this._getTypedCPParameters(credentialProviderParameters, modelId);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)id)) {
                id = StringUtils.generateKey();
            } else {
                this._keepExistingCredentialProviderPassword(up, modelId, typedParamValues, id);
            }
            if ((credentialProvider = this._credentialProviderFactory.createCredentialProvider(id, modelId, typedParamValues, additionnalLabel)) == null) continue;
            cps.add(credentialProvider);
        }
        up.setCredentialProviders(cps);
    }

    private void _keepExistingUserDirectoryPassword(UserPopulation up, String modelId, Map<String, Object> typedParamValues, String id) {
        UserDirectory existingUserDirectory = up.getUserDirectory(id);
        UserDirectoryModel userDirectoryModel = this._userDirectoryFactory.getExtension(modelId);
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)modelId, (CharSequence)userDirectoryModel.getId())) {
            for (Map.Entry<String, ? extends ElementDefinition> parameterEntry : userDirectoryModel.getParameters().entrySet()) {
                ElementDefinition parameter = parameterEntry.getValue();
                if (!"password".equals(parameter.getType().getId()) || typedParamValues.get(parameterEntry.getKey()) != null) continue;
                typedParamValues.put(parameterEntry.getKey(), existingUserDirectory.getParameterValues().get(parameterEntry.getKey()));
            }
        }
    }

    private void _keepExistingCredentialProviderPassword(UserPopulation up, String modelId, Map<String, Object> typedParamValues, String id) {
        CredentialProvider existingCredentialProvider = up.getCredentialProvider(id);
        CredentialProviderModel credentialProviderModel = this._credentialProviderFactory.getExtension(modelId);
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)modelId, (CharSequence)credentialProviderModel.getId())) {
            for (Map.Entry<String, ? extends ElementDefinition> parameterEntry : credentialProviderModel.getParameters().entrySet()) {
                ElementDefinition parameter = parameterEntry.getValue();
                if (!"password".equals(parameter.getType().getId()) || typedParamValues.get(parameterEntry.getKey()) != null) continue;
                typedParamValues.put(parameterEntry.getKey(), existingCredentialProvider.getParameterValues().get(parameterEntry.getKey()));
            }
        }
    }

    private Map<String, Object> _getTypedUDParameters(Map<String, String> parameters, String modelId) {
        LinkedHashMap<String, Object> resultParameters = new LinkedHashMap<String, Object>();
        UserDirectoryModel model = this._userDirectoryFactory.getExtension(modelId);
        if (model == null) {
            throw new IllegalStateException("The user population configuration refers to an unexisting extension for the user directory '" + modelId + "'");
        }
        Map<String, ? extends ElementDefinition> declaredParameters = model.getParameters();
        for (String paramNameWithPrefix : parameters.keySet()) {
            String[] splitStr = paramNameWithPrefix.split("\\$", 2);
            String prefix = splitStr[0];
            String paramName = splitStr[1];
            if (prefix.equals(modelId) && declaredParameters.containsKey(paramName)) {
                String originalValue = parameters.get(paramNameWithPrefix);
                ElementDefinition parameter = declaredParameters.get(paramName);
                ElementType type = parameter.getType();
                Object typedValue = type.castValue(originalValue);
                resultParameters.put(paramName, typedValue);
                continue;
            }
            if (!prefix.equals(modelId)) continue;
            this.getLogger().warn("The parameter {} is not declared in extension {}. It will be ignored", (Object)paramName, (Object)modelId);
        }
        return resultParameters;
    }

    private Map<String, Object> _getTypedCPParameters(Map<String, String> parameters, String modelId) {
        LinkedHashMap<String, Object> resultParameters = new LinkedHashMap<String, Object>();
        CredentialProviderModel model = this._credentialProviderFactory.getExtension(modelId);
        if (model == null) {
            throw new IllegalStateException("The user population configuration refers to an unexisting extension for the credential provider '" + modelId + "'");
        }
        Map<String, ? extends ElementDefinition> declaredParameters = model.getParameters();
        for (String paramNameWithPrefix : parameters.keySet()) {
            String[] splitStr = paramNameWithPrefix.split("\\$", 2);
            String prefix = splitStr[0];
            String paramName = splitStr[1];
            if (prefix.equals(modelId) && declaredParameters.containsKey(paramName)) {
                String originalValue = parameters.get(paramNameWithPrefix);
                ElementDefinition parameter = declaredParameters.get(paramName);
                ElementType type = parameter.getType();
                Object typedValue = type.castValue(originalValue);
                resultParameters.put(paramName, typedValue);
                continue;
            }
            if (!prefix.equals(modelId)) continue;
            this.getLogger().warn("The parameter {} is not declared in extension {}. It will be ignored", (Object)paramName, (Object)modelId);
        }
        return resultParameters;
    }

    @Callable
    public Map<String, Object> remove(String id) {
        return this.remove(id, false);
    }

    public Map<String, Object> remove(String id, boolean forceDeletion) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (ADMIN_POPULATION_ID.equals("id")) {
            return null;
        }
        if (!forceDeletion && this._populationConsumerEP.isInUse(id)) {
            this.getLogger().error("The UserPopulation with id '{}' is used, it cannot be removed.", (Object)id);
            result.put("error", "used");
            return result;
        }
        this._readPopulations(false);
        UserPopulation up = this._userPopulations.remove(id);
        if (up == null) {
            this.getLogger().error("The UserPopulation with id '{}' does not exist, it cannot be removed.", (Object)id);
            result.put("error", "unknown");
            return result;
        }
        up.dispose();
        if (this._writePopulations()) {
            result.put("error", "server");
            return result;
        }
        if (this._observationManager != null) {
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("userpopulation-id", id);
            this._observationManager.notify(new Event("userpopulation.deleted", this._currentUserProvider.getUser(), eventParams));
        }
        result.put("id", id);
        return result;
    }

    @Callable
    public Map<String, Object> enable(String populationId, boolean enabled) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        UserPopulation population = this.getUserPopulation(populationId);
        if (population != null) {
            population.enable(enabled);
            result.put("id", populationId);
        } else {
            this.getLogger().error("The UserPopulation with id '{}' does not exist, it cannot be enabled/disabled.", (Object)populationId);
            result.put("error", "unknown");
        }
        if (this._writePopulations()) {
            result.put("error", "server");
            return result;
        }
        return result;
    }

    @Callable
    public boolean isValid(String populationId) {
        return !this._misconfiguredUserPopulations.contains(populationId);
    }

    @Callable
    public Map<String, Object> isEnabled(String populationId) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        UserPopulation population = this.getUserPopulation(populationId);
        if (population != null) {
            result.put("enabled", population.isEnabled());
        } else {
            result.put("error", "unknown");
        }
        return result;
    }

    @Callable
    public Map<String, Object> canRemove(String populationId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("canRemove", !this._populationConsumerEP.isInUse(populationId));
        return result;
    }

    private synchronized void _readPopulations(boolean forceRead) {
        try {
            if (!__USER_POPULATIONS_FILE.exists()) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("No user population file found at {}. Creating a new one.", (Object)__USER_POPULATIONS_FILE.getAbsolutePath());
                }
                this._createPopulationsFile(__USER_POPULATIONS_FILE);
            }
            long fileLastModified = __USER_POPULATIONS_FILE.lastModified() / 1000L * 1000L;
            if (forceRead || fileLastModified >= this._lastFileReading) {
                this.getLogger().debug("Reading user population file at {}", (Object)__USER_POPULATIONS_FILE.getAbsolutePath());
                long lastFileReading = Instant.now().truncatedTo(ChronoUnit.SECONDS).toEpochMilli();
                LinkedHashMap<String, UserPopulation> userPopulations = new LinkedHashMap<String, UserPopulation>();
                HashSet<String> ignoredPopulations = new HashSet<String>();
                HashSet<String> misconfiguredUserPopulations = new HashSet<String>();
                Configuration cfg = new DefaultConfigurationBuilder().buildFromFile(__USER_POPULATIONS_FILE);
                for (Configuration childCfg : cfg.getChildren("userPopulation")) {
                    try {
                        UserPopulation up = this._configurePopulation(childCfg, misconfiguredUserPopulations);
                        userPopulations.put(up.getId(), up);
                    }
                    catch (ConfigurationException e) {
                        this.getLogger().error("Fatal configuration error for population of id '{}'. The population will be ignored.", (Object)childCfg.getAttribute("id", ""), (Object)e);
                        ignoredPopulations.add(childCfg.getAttribute("id", ""));
                    }
                }
                this.getLogger().debug("User population file read. Found {} valid population(s), {} invalid population(s) and {} misconfigured population(s)", new Object[]{userPopulations.size(), ignoredPopulations.size(), misconfiguredUserPopulations.size()});
                this.dispose();
                this._lastFileReading = lastFileReading;
                this._userPopulations = userPopulations;
                this._ignoredPopulations = ignoredPopulations;
                this._misconfiguredUserPopulations = misconfiguredUserPopulations;
            } else if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("No need to reload the user population file. The file modified at {} was not modified since {}", (Object)fileLastModified, (Object)this._lastFileReading);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Failed to retrieve user populations from the configuration file " + __USER_POPULATIONS_FILE, (Throwable)e);
        }
    }

    private void _createPopulationsFile(File file) throws IOException, TransformerConfigurationException, SAXException {
        file.createNewFile();
        try (FileOutputStream os = new FileOutputStream(file);){
            TransformerHandler th = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
            StreamResult result = new StreamResult(os);
            th.setResult(result);
            Properties format = new Properties();
            format.put("method", "xml");
            format.put("indent", "yes");
            format.put("encoding", "UTF-8");
            format.put("{http://xml.apache.org/xalan}indent-amount", "4");
            th.getTransformer().setOutputProperties(format);
            th.startDocument();
            XMLUtils.createElement((ContentHandler)th, (String)"userPopulations");
            th.endDocument();
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Empty file for user populations created");
        }
    }

    private UserPopulation _configurePopulation(Configuration configuration, Set<String> misconfiguredUserPopulations) throws ConfigurationException {
        UserPopulation up = new UserPopulation();
        String upId = configuration.getAttribute("id");
        up.setId(upId);
        up.setLabel(new I18nizableText(configuration.getChild("label").getValue()));
        List<UserDirectory> userDirectories = this._configureUserDirectories(configuration, upId, misconfiguredUserPopulations);
        up.setUserDirectories(userDirectories);
        List<CredentialProvider> credentialProviders = this._configureCredentialProviders(configuration, upId);
        up.setCredentialProviders(credentialProviders);
        boolean enabled = configuration.getAttributeAsBoolean("enabled", true) && userDirectories.size() > 0 && credentialProviders.size() > 0;
        up.enable(enabled);
        return up;
    }

    private List<UserDirectory> _configureUserDirectories(Configuration configuration, String upId, Set<String> misconfiguredUserPopulations) throws ConfigurationException {
        Configuration[] userDirectoriesConf;
        ArrayList<UserDirectory> userDirectories = new ArrayList<UserDirectory>();
        for (Configuration userDirectoryConf : userDirectoriesConf = configuration.getChild("userDirectories").getChildren("userDirectory")) {
            String id = userDirectoryConf.getAttribute("id");
            String modelId = userDirectoryConf.getAttribute("modelId");
            String label = userDirectoryConf.getAttribute("label", null);
            try {
                Map<String, Object> paramValues = this._getUDParametersFromConfiguration(userDirectoryConf, modelId, upId);
                UserDirectory ud = this._userDirectoryFactory.createUserDirectory(id, modelId, paramValues, upId, label);
                if (ud == null) continue;
                userDirectories.add(ud);
            }
            catch (Exception e) {
                this.getLogger().warn("The population of id '" + upId + "' declares a user directory with an invalid configuration", (Throwable)e);
                misconfiguredUserPopulations.add(upId);
            }
        }
        if (userDirectories.isEmpty()) {
            misconfiguredUserPopulations.add(upId);
            this.getLogger().warn("The population of id '" + upId + "' does not have user directory with a valid configuration. It will be disabled until it will be fixed.");
        }
        return userDirectories;
    }

    private List<CredentialProvider> _configureCredentialProviders(Configuration configuration, String upId) throws ConfigurationException {
        Configuration[] credentialProvidersConf;
        ArrayList<CredentialProvider> credentialProviders = new ArrayList<CredentialProvider>();
        for (Configuration credentialProviderConf : credentialProvidersConf = configuration.getChild("credentialProviders").getChildren("credentialProvider")) {
            String id = credentialProviderConf.getAttribute("id");
            String modelId = credentialProviderConf.getAttribute("modelId");
            String additionnalLabel = credentialProviderConf.getAttribute("label", null);
            try {
                Map<String, Object> paramValues = this._getCPParametersFromConfiguration(credentialProviderConf, modelId, upId);
                CredentialProvider cp = this._credentialProviderFactory.createCredentialProvider(id, modelId, paramValues, additionnalLabel);
                if (cp == null) continue;
                credentialProviders.add(cp);
            }
            catch (Exception e) {
                this.getLogger().warn("The population of id '" + upId + "' declares a credential provider with an invalid configuration", (Throwable)e);
                this._misconfiguredUserPopulations.add(upId);
            }
        }
        if (credentialProviders.isEmpty()) {
            this._misconfiguredUserPopulations.add(upId);
            this.getLogger().warn("The population of id '" + upId + "' does not have credential provider with a valid configuration. It will be disabled until it will be fixed.");
        }
        return credentialProviders;
    }

    private Map<String, Object> _getUDParametersFromConfiguration(Configuration conf, String modelId, String populationId) throws ConfigurationException, IllegalArgumentException {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        if (!this._userDirectoryFactory.hasExtension(modelId)) {
            throw new IllegalArgumentException(String.format("The population of id '%s' declares a non-existing user directory model with id '%s'. It will be ignored.", populationId, modelId));
        }
        Map<String, ? extends ElementDefinition> declaredParameters = this._userDirectoryFactory.getExtension(modelId).getParameters();
        for (String udParamName : declaredParameters.keySet()) {
            ElementType type = declaredParameters.get(udParamName).getType();
            assert (type instanceof XMLElementType);
            Object typedValue = ((XMLElementType)type).read(conf, udParamName);
            if (typedValue == null) {
                throw new ConfigurationException(String.format("The population of id '%s' declares a user directory model with id '%s' but the parameter '%s' is missing. This user directory will be ignored.", populationId, modelId, udParamName));
            }
            parameters.put(udParamName, typedValue);
        }
        return parameters;
    }

    private Map<String, Object> _getCPParametersFromConfiguration(Configuration conf, String modelId, String populationId) throws ConfigurationException, IllegalArgumentException {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        if (!this._credentialProviderFactory.hasExtension(modelId)) {
            throw new IllegalArgumentException(String.format("The population of id '%s' declares a non-existing credential provider model with id '%s'. It will be ignored.", populationId, modelId));
        }
        Map<String, ? extends ElementDefinition> declaredParameters = this._credentialProviderFactory.getExtension(modelId).getParameters();
        for (String cpParamName : declaredParameters.keySet()) {
            ElementType type = declaredParameters.get(cpParamName).getType();
            assert (type instanceof XMLElementType);
            Object typedValue = ((XMLElementType)type).read(conf, cpParamName);
            if (typedValue == null) {
                throw new ConfigurationException(String.format("The population of id '%s' declares a credential provider model with id '%s' but the parameter '%s' is missing. This credential provider will be ignored.", populationId, modelId, cpParamName));
            }
            parameters.put(cpParamName, typedValue);
        }
        return parameters;
    }

    private boolean _writePopulations() {
        File backup = new File(__USER_POPULATIONS_FILE.getPath() + ".tmp");
        boolean errorOccured = false;
        try {
            Files.copy(__USER_POPULATIONS_FILE.toPath(), backup.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            this.getLogger().error("Error when creating backup '" + __USER_POPULATIONS_FILE + "' file", (Throwable)e);
        }
        try (FileOutputStream os = new FileOutputStream(__USER_POPULATIONS_FILE);){
            TransformerHandler th = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
            StreamResult result = new StreamResult(os);
            th.setResult(result);
            Properties format = new Properties();
            format.put("method", "xml");
            format.put("indent", "yes");
            format.put("encoding", "UTF-8");
            format.put("{http://xml.apache.org/xalan}indent-amount", "4");
            th.getTransformer().setOutputProperties(format);
            try {
                this._toSAX(th);
            }
            catch (Exception e) {
                this.getLogger().error("Error when saxing the userPopulations", (Throwable)e);
                errorOccured = true;
            }
        }
        catch (IOException | TransformerConfigurationException | TransformerFactoryConfigurationError e) {
            this.getLogger().error("Error when trying to modify the user populations with the configuration file " + __USER_POPULATIONS_FILE, e);
        }
        try {
            if (errorOccured) {
                Files.copy(backup.toPath(), __USER_POPULATIONS_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this._readPopulations(true);
            }
            Files.deleteIfExists(backup.toPath());
        }
        catch (IOException e) {
            this.getLogger().error("Error when restoring backup '" + __USER_POPULATIONS_FILE + "' file", (Throwable)e);
        }
        return errorOccured;
    }

    private void _toSAX(TransformerHandler handler) {
        try {
            handler.startDocument();
            XMLUtils.startElement((ContentHandler)handler, (String)"userPopulations");
            for (UserPopulation up : this._userPopulations.values()) {
                this._saxUserPopulation(up, handler);
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"userPopulations");
            handler.endDocument();
        }
        catch (SAXException e) {
            this.getLogger().error("Error when saxing the userPopulations", (Throwable)e);
        }
    }

    private void _saxUserPopulation(UserPopulation userPopulation, TransformerHandler handler) {
        try {
            ElementDefinition definition;
            Object value;
            Map<String, Object> paramValues;
            Map<String, ? extends ElementDefinition> definitions;
            AttributesImpl attr;
            AttributesImpl atts = new AttributesImpl();
            atts.addCDATAAttribute("id", userPopulation.getId());
            atts.addCDATAAttribute("enabled", Boolean.toString(userPopulation.isEnabled()));
            XMLUtils.startElement((ContentHandler)handler, (String)"userPopulation", (Attributes)atts);
            userPopulation.getLabel().toSAX(handler, "label");
            XMLUtils.startElement((ContentHandler)handler, (String)"userDirectories");
            for (UserDirectory ud : userPopulation.getUserDirectories()) {
                attr = new AttributesImpl();
                attr.addCDATAAttribute("id", ud.getId());
                attr.addCDATAAttribute("modelId", ud.getUserDirectoryModelId());
                attr.addCDATAAttribute("label", ud.getLabel() != null ? ud.getLabel() : "");
                XMLUtils.startElement((ContentHandler)handler, (String)"userDirectory", (Attributes)attr);
                UserDirectoryModel udModel = this._userDirectoryFactory.getExtension(ud.getUserDirectoryModelId());
                definitions = udModel.getParameters();
                paramValues = ud.getParameterValues();
                for (String paramName : paramValues.keySet()) {
                    value = paramValues.get(paramName);
                    definition = definitions.get(paramName);
                    if (definition == null) continue;
                    definition.getType().saxValue(handler, paramName, value, null);
                }
                XMLUtils.endElement((ContentHandler)handler, (String)"userDirectory");
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"userDirectories");
            XMLUtils.startElement((ContentHandler)handler, (String)"credentialProviders");
            for (CredentialProvider cp : userPopulation.getCredentialProviders()) {
                attr = new AttributesImpl();
                attr.addCDATAAttribute("id", cp.getId());
                attr.addCDATAAttribute("modelId", cp.getCredentialProviderModelId());
                attr.addCDATAAttribute("label", cp.getLabel() != null ? cp.getLabel() : "");
                XMLUtils.startElement((ContentHandler)handler, (String)"credentialProvider", (Attributes)attr);
                CredentialProviderModel cpModel = this._credentialProviderFactory.getExtension(cp.getCredentialProviderModelId());
                definitions = cpModel.getParameters();
                paramValues = cp.getParameterValues();
                for (String paramName : paramValues.keySet()) {
                    value = paramValues.get(paramName);
                    definition = definitions.get(paramName);
                    if (definition == null) continue;
                    definition.getType().saxValue(handler, paramName, value, null);
                }
                XMLUtils.endElement((ContentHandler)handler, (String)"credentialProvider");
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"credentialProviders");
            XMLUtils.endElement((ContentHandler)handler, (String)"userPopulation");
        }
        catch (SAXException e) {
            this.getLogger().error("Error when saxing the userPopulation " + userPopulation, (Throwable)e);
        }
    }

    public void dispose() {
        for (UserPopulation up : this._userPopulations.values()) {
            up.dispose();
        }
        this._userPopulations.clear();
        this._lastFileReading = 0L;
    }
}

