/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.userpref;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ametys.core.userpref.UserPreference;
import org.ametys.core.userpref.UserPreferenceProvider;
import org.ametys.core.userpref.UserPreferencesErrors;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.Errors;
import org.ametys.runtime.parameter.ParameterHelper;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.apache.commons.lang.StringUtils;

public class UserPreferencesExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<UserPreferenceProvider> {
    public static final String ROLE = UserPreferencesExtensionPoint.class.getName();
    private UserPrefOrderComparator _comparator;

    @Override
    public void initialize() throws Exception {
        super.initialize();
        this._comparator = new UserPrefOrderComparator();
    }

    public UserPreference getUserPreference(Map<String, String> contextVars, String id) {
        for (String extensionId : this.getExtensionsIds()) {
            UserPreferenceProvider provider = (UserPreferenceProvider)this.getExtension(extensionId);
            for (UserPreference preference : provider.getPreferences(contextVars)) {
                if (!preference.getId().equals(id)) continue;
                return preference;
            }
        }
        return null;
    }

    public Map<String, UserPreference> getUserPreferences(Map<String, String> contextVars) {
        return Collections.unmodifiableMap(this.getPreferencesMap(contextVars));
    }

    public Map<I18nizableText, List<UserPreference>> getCategorizedPreferences(Map<String, String> contextVars) {
        return Collections.unmodifiableMap(this.getCategorizedPreferencesMap(contextVars));
    }

    public void validatePreferences(Map<String, String> contextVars, Map<String, String> values, UserPreferencesErrors errors) {
        Map<String, UserPreference> preferences = this.getPreferencesMap(contextVars);
        for (Map.Entry<String, String> entry : values.entrySet()) {
            UserPreference pref = preferences.get(entry.getKey());
            if (pref == null) continue;
            String value = entry.getValue();
            Object castValue = ParameterHelper.castValue(value, (ParameterHelper.ParameterType)((Object)pref.getType()));
            if (StringUtils.isNotEmpty((String)value) && castValue == null) {
                errors.addError(pref.getId(), new I18nizableText("plugin.core", "PLUGINS_CORE_UI_USER_PREFERENCES_INVALID_TYPE"));
                continue;
            }
            Validator validator = pref.getValidator();
            if (validator == null) continue;
            Errors fieldErrors = new Errors();
            pref.getValidator().validate(castValue == null ? value : castValue, fieldErrors);
            if (!fieldErrors.hasErrors()) continue;
            errors.addErrors(pref.getId(), fieldErrors.getErrors());
        }
    }

    protected Map<String, UserPreference> getPreferencesMap(Map<String, String> contextVars) {
        HashMap<String, UserPreference> preferences = new HashMap<String, UserPreference>();
        for (String extensionId : this.getExtensionsIds()) {
            UserPreferenceProvider provider = (UserPreferenceProvider)this.getExtension(extensionId);
            for (UserPreference preference : provider.getPreferences(contextVars)) {
                preferences.put(preference.getId(), preference);
            }
        }
        return preferences;
    }

    protected Map<I18nizableText, List<UserPreference>> getCategorizedPreferencesMap(Map<String, String> contextVars) {
        TreeMap<I18nizableText, List<UserPreference>> preferences = new TreeMap<I18nizableText, List<UserPreference>>(new I18nizableTextComparator());
        for (String extensionId : this.getExtensionsIds()) {
            UserPreferenceProvider provider = (UserPreferenceProvider)this.getExtension(extensionId);
            for (UserPreference preference : provider.getPreferences(contextVars)) {
                I18nizableText groupName = preference.getDisplayGroup();
                ArrayList<UserPreference> group = (ArrayList<UserPreference>)preferences.get(groupName);
                if (group == null) {
                    group = new ArrayList<UserPreference>();
                    preferences.put(groupName, group);
                }
                group.add(preference);
            }
        }
        for (List group : preferences.values()) {
            Collections.sort(group, this._comparator);
        }
        return preferences;
    }

    class I18nizableTextComparator
    implements Comparator<I18nizableText> {
        I18nizableTextComparator() {
        }

        @Override
        public int compare(I18nizableText t1, I18nizableText t2) {
            return t1.toString().compareTo(t2.toString());
        }
    }

    class UserPrefOrderComparator
    implements Comparator<UserPreference> {
        UserPrefOrderComparator() {
        }

        @Override
        public int compare(UserPreference pref1, UserPreference pref2) {
            return pref1.getOrder() - pref2.getOrder();
        }
    }
}

