/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.ametys.core.util.I18nUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class I18nizableTextSerializer
extends StdSerializer<I18nizableText>
implements Component,
Serviceable,
LogEnabled {
    public static final String ROLE = I18nizableTextSerializer.class.getName();
    private I18nUtils _i18nUtils;
    private Logger _logger;

    public I18nizableTextSerializer() {
        super(I18nizableText.class);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._i18nUtils = (I18nUtils)((Object)manager.lookup(I18nUtils.ROLE));
    }

    public void enableLogging(Logger logger) {
        this._logger = logger;
    }

    public void serialize(I18nizableText value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (value.isI18n()) {
            String msg = this._i18nUtils.translate(value);
            if (msg == null) {
                if (this._logger.isWarnEnabled()) {
                    this._logger.warn("Translation not found for key " + value.getKey() + " in catalogue " + value.getCatalogue());
                }
                jgen.writeString(value.getCatalogue() + ':' + value.getKey());
            } else {
                jgen.writeString(msg);
            }
        } else {
            jgen.writeString(value.getLabel());
        }
    }
}

