/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.util.I18nizableTextSerializer;
import org.ametys.plugins.core.ui.help.HelpSerializer;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class JSONUtils
implements Component,
ThreadSafe,
Serviceable,
Initializable {
    public static final String ROLE = JSONUtils.class.getName();
    private JsonFactory _jsonFactory = new JsonFactory();
    private ObjectMapper _objectMapper = new ObjectMapper();
    private I18nizableTextSerializer _i18nizableTextSerializer;
    private HelpSerializer _helpSerializer;

    public void service(ServiceManager manager) throws ServiceException {
        this._i18nizableTextSerializer = (I18nizableTextSerializer)((Object)manager.lookup(I18nizableTextSerializer.ROLE));
        this._helpSerializer = (HelpSerializer)manager.lookup(HelpSerializer.ROLE);
    }

    public void initialize() throws Exception {
        SimpleModule i18nModule = new SimpleModule("AmetysI18nModule", new Version(1, 0, 0, null, null, null));
        i18nModule.addSerializer((JsonSerializer)this._i18nizableTextSerializer);
        this._objectMapper.registerModule((Module)i18nModule);
        SimpleModule helpModule = new SimpleModule("AmetysHelpModule", new Version(1, 0, 0, null, null, null));
        helpModule.addSerializer((JsonSerializer)this._helpSerializer);
        this._objectMapper.registerModule((Module)helpModule);
    }

    public Map<String, Object> convertJsonToMap(String jsonString) {
        try {
            if (StringUtils.isNotBlank((String)jsonString)) {
                JsonParser jParser = this._jsonFactory.createParser((Reader)new StringReader(jsonString));
                Map map = (Map)this._objectMapper.readValue(jParser, LinkedHashMap.class);
                return map;
            }
            return new LinkedHashMap<String, Object>();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The json string " + jsonString + " can not be parsed as a Map.", e);
        }
    }

    public List<Object> convertJsonToList(String jsonString) {
        try {
            if (StringUtils.isNotBlank((String)jsonString)) {
                JsonParser jParser = this._jsonFactory.createParser((Reader)new StringReader(jsonString));
                List list = (List)this._objectMapper.readValue(jParser, ArrayList.class);
                return list;
            }
            return new ArrayList<Object>();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The json string " + jsonString + " can not be parsed as a List.", e);
        }
    }

    public Object[] convertJsonToArray(String jsonString) {
        try {
            if (StringUtils.isNotBlank((String)jsonString)) {
                JsonParser jParser = this._jsonFactory.createParser((Reader)new StringReader(jsonString));
                Object[] array = (Object[])this._objectMapper.readValue(jParser, Object[].class);
                return array;
            }
            return new Object[0];
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The json string " + jsonString + " can not be parsed as an array.", e);
        }
    }

    public String[] convertJsonToStringArray(String jsonString) {
        try {
            if (StringUtils.isNotBlank((String)jsonString)) {
                JsonParser jParser = this._jsonFactory.createParser((Reader)new StringReader(jsonString));
                String[] array = (String[])this._objectMapper.readValue(jParser, String[].class);
                return array;
            }
            return new String[0];
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The json string " + jsonString + " can not be parsed as a String array.", e);
        }
    }

    public void convertObjectToJson(OutputStream out, Object parameters) {
        try {
            JsonGenerator jsonGenerator = this._jsonFactory.createGenerator(out, JsonEncoding.UTF8);
            this._objectMapper.writeValue(jsonGenerator, parameters);
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The object can not be converted to json string", e);
        }
    }

    public String convertObjectToJson(Object parameters) {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator jsonGenerator = this._jsonFactory.createGenerator((Writer)writer);
            this._objectMapper.writeValue(jsonGenerator, parameters);
            return writer.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The object can not be converted to json string", e);
        }
    }
}

