/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringUtils {
    private static final Logger __LOGGER = LoggerFactory.getLogger(StringUtils.class);

    private StringUtils() {
    }

    public static Collection<String> stringToCollection(String values) {
        ArrayList<String> result = new ArrayList<String>();
        if (values != null && values.length() > 0) {
            StringTokenizer stk = new StringTokenizer(values, ",");
            while (stk.hasMoreTokens()) {
                result.add(stk.nextToken().trim());
            }
        }
        return result;
    }

    public static String[] stringToStringArray(String values) {
        Collection<String> coll = StringUtils.stringToCollection(values);
        return coll.toArray(new String[coll.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateKey() {
        Class<StringUtils> clazz = StringUtils.class;
        synchronized (StringUtils.class) {
            long value = System.currentTimeMillis();
            try {
                Thread.sleep(15L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String longString = Long.toString(value, 36);
            return longString;
        }
    }

    public static String md5Base64(String password) {
        MessageDigest md5;
        if (password == null) {
            return null;
        }
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            __LOGGER.error("Cannot encode the password to md5Base64", (Throwable)e);
            return null;
        }
        md5.reset();
        try {
            md5.update(password.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        byte[] hash = md5.digest();
        try {
            return new String(Base64.encodeBase64((byte[])hash), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String encode(String url) {
        try {
            String encodedUrl = URLEncoder.encode(url, "UTF-8");
            return encodedUrl.replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }
}

