/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public final class URLEncoder {
    private static final String __NAME_VALUE_SEPARATOR = "=";
    private static final String __PARAMETER_SEPARATOR = "&";

    private URLEncoder() {
    }

    public static String encodeParameter(String value) {
        try {
            return java.net.URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to encode parameter " + value, e);
        }
    }

    public static String encodePath(String path) {
        try {
            return new URI(null, null, path, null, null).toASCIIString().replaceAll("\\+", "%2B");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to encode path " + path, e);
        }
    }

    public static String encodeURI(String path, Map<String, String> parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append(URLEncoder.encodePath(path));
        if (parameters != null && !parameters.isEmpty()) {
            StringBuilder query = new StringBuilder();
            for (String paramName : parameters.keySet()) {
                String encodedName = URLEncoder.encodeParameter(paramName);
                String encodedValue = URLEncoder.encodeParameter(parameters.get(paramName));
                if (query.length() > 0) {
                    query.append(__PARAMETER_SEPARATOR);
                }
                query.append(encodedName).append(__NAME_VALUE_SEPARATOR).append(encodedValue);
            }
            sb.append("?").append(query.toString());
        }
        return sb.toString();
    }
}

