/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.authentication;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.core.authentication.BlockingCredentialProvider;
import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.authentication.CredentialProviderFactory;
import org.ametys.core.authentication.CredentialProviderModel;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.impl.authentication.FormCredentialProvider;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class LoginScreenGenerator
extends ServiceableGenerator {
    protected CredentialProviderFactory _credentialProviderFactory;
    protected UserPopulationDAO _userPopulationDAO;
    protected JSONUtils _jsonUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._credentialProviderFactory = (CredentialProviderFactory)smanager.lookup(CredentialProviderFactory.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)smanager.lookup(UserPopulationDAO.ROLE);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"LoginScreen");
        boolean isAmetysPublic = Config.getInstance() != null ? (Boolean)Config.getInstance().getValue("runtime.ametys.public") : false;
        boolean invalidPopulationIds = "true".equals(request.getParameter("invalidPopulationIds"));
        boolean shouldDisplayUserPopulationsList = "true".equals(request.getParameter("shouldDisplayUserPopulationsList"));
        List usersPopulations = null;
        String usersPopulationsIdsAsString = request.getParameter("usersPopulations");
        if (usersPopulationsIdsAsString != null) {
            usersPopulations = Arrays.stream(usersPopulationsIdsAsString.split(",")).map(this._userPopulationDAO::getUserPopulation).collect(Collectors.toList());
        }
        String chosenPopulationId = request.getParameter("chosenPopulationId");
        if (shouldDisplayUserPopulationsList) {
            this._generatePopulations(usersPopulations, isAmetysPublic, invalidPopulationIds, chosenPopulationId);
        }
        boolean availableCredentialProviders = "true".equals(request.getParameter("availableCredentialProviders"));
        List<CredentialProvider> credentialProviders = null;
        if (availableCredentialProviders && usersPopulations != null && !usersPopulations.isEmpty()) {
            credentialProviders = StringUtils.isNotBlank((CharSequence)chosenPopulationId) ? usersPopulations.stream().filter(userPop -> chosenPopulationId.equals(userPop.getId())).findAny().get().getCredentialProviders() : ((UserPopulation)usersPopulations.get(0)).getCredentialProviders();
        }
        int credentialProviderIndex = Integer.parseInt(request.getParameter("credentialProviderIndex"));
        this._generateCredentialProviders(credentialProviders, credentialProviderIndex);
        this._generateLoginForm(request, credentialProviders, credentialProviderIndex, invalidPopulationIds, chosenPopulationId != null || usersPopulations == null ? chosenPopulationId : ((UserPopulation)usersPopulations.get(0)).getId());
        String contextsAsString = request.getParameter("contexts");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"contexts", (String)contextsAsString);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"LoginScreen");
        this.contentHandler.endDocument();
    }

    private void _generatePopulations(List<UserPopulation> usersPopulations, boolean isAmetysPublic, boolean tryedAnInvalidPopulationId, String chosenPopulationId) throws SAXException {
        if (usersPopulations != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("invalid", tryedAnInvalidPopulationId ? "true" : "false");
            attrs.addCDATAAttribute("public", isAmetysPublic ? "true" : "false");
            attrs.addCDATAAttribute("size", Integer.toString(usersPopulations.size()));
            if (chosenPopulationId != null) {
                attrs.addCDATAAttribute("currentValue", chosenPopulationId);
            }
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"UserPopulations", (Attributes)attrs);
            if (!isAmetysPublic) {
                for (UserPopulation up : usersPopulations) {
                    AttributesImpl attrs2 = new AttributesImpl();
                    attrs2.addCDATAAttribute("id", up.getId());
                    XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"UserPopulation", (Attributes)attrs2);
                    up.getLabel().toSAX(this.contentHandler, "label");
                    XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"UserPopulation");
                }
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"UserPopulations");
        }
    }

    private void _generateCredentialProviders(List<CredentialProvider> credentialProviders, int currentCredentialProvider) throws SAXException {
        if (credentialProviders == null) {
            return;
        }
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"CredentialProviders");
        for (int index = 0; index < credentialProviders.size(); ++index) {
            CredentialProvider cp = credentialProviders.get(index);
            if (!(cp instanceof BlockingCredentialProvider)) continue;
            CredentialProviderModel cpModel = this._credentialProviderFactory.getExtension(cp.getCredentialProviderModelId());
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("index", String.valueOf(index));
            attrs.addCDATAAttribute("selected", index == currentCredentialProvider ? "true" : "false");
            attrs.addCDATAAttribute("isForm", cp instanceof FormCredentialProvider ? "true" : "false");
            attrs.addCDATAAttribute("isNewWindowRequired", cp instanceof BlockingCredentialProvider && ((BlockingCredentialProvider)cp).requiresNewWindow() ? "true" : "false");
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"CredentialProvider", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"label", (String)I18nUtils.getInstance().translate(cpModel.getConnectionLabel()));
            if (StringUtils.isNotBlank((CharSequence)cp.getLabel())) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"additionalLabel", (String)cp.getLabel());
            }
            if (StringUtils.isNotEmpty((CharSequence)cpModel.getIconGlyph())) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"iconGlyph", (String)cpModel.getIconGlyph());
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"iconDecorator", (String)cpModel.getIconDecorator());
            } else if (StringUtils.isNotEmpty((CharSequence)cpModel.getIconMedium())) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"iconMedium", (String)cpModel.getIconMedium());
            }
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"color", (String)cpModel.getColor());
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"CredentialProvider");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"CredentialProviders");
    }

    private void _generateLoginForm(Request request, List<CredentialProvider> credentialProviders, int currentCredentialProvider, boolean invalidPopulationIds, String chosenPopulationId) throws SAXException {
        String login;
        if (credentialProviders == null) {
            return;
        }
        FormCredentialProvider formBasedCP = null;
        if (currentCredentialProvider != -1 && credentialProviders.get(currentCredentialProvider) instanceof FormCredentialProvider) {
            formBasedCP = (FormCredentialProvider)credentialProviders.get(currentCredentialProvider);
        } else {
            Optional<CredentialProvider> foundAnyFormCredentialProvider = credentialProviders.stream().filter(cp -> cp instanceof FormCredentialProvider).findAny();
            if (foundAnyFormCredentialProvider.isPresent()) {
                formBasedCP = (FormCredentialProvider)foundAnyFormCredentialProvider.get();
            } else {
                return;
            }
        }
        boolean useCaptcha = (Boolean)formBasedCP.getParameterValues().get("runtime.authentication.form.captcha");
        boolean autoComplete = true;
        boolean rememberMe = (Boolean)formBasedCP.getParameterValues().get("runtime.authentication.form.cookies");
        boolean allowLoginByEmail = (Boolean)formBasedCP.getParameterValues().get("runtime.authentication.form.login-by-email");
        boolean captcha = false;
        if (useCaptcha && StringUtils.isNotBlank((CharSequence)(login = request.getParameter("login"))) && StringUtils.isNotBlank((CharSequence)chosenPopulationId)) {
            int nbConnect = formBasedCP.requestNbConnectBDD(login, chosenPopulationId);
            captcha = nbConnect >= FormCredentialProvider.NB_CONNECTION_ATTEMPTS;
        }
        boolean showErrors = !invalidPopulationIds;
        AttributesImpl attrs = new AttributesImpl();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"LoginForm", (Attributes)attrs);
        if (StringUtils.isNotBlank((CharSequence)formBasedCP.getLabel())) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"additionalLabel", (String)formBasedCP.getLabel());
        }
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"autocomplete", (String)String.valueOf(autoComplete));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"rememberMe", (String)String.valueOf(rememberMe));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"useCaptcha", (String)String.valueOf(captcha));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"autocomplete", (String)String.valueOf(autoComplete));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"allowLoginByEmail", (String)String.valueOf(allowLoginByEmail));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"showErrors", (String)String.valueOf(showErrors));
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"LoginForm");
    }
}

