/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.group;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupDirectoryDAO;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.group.InvalidModificationException;
import org.ametys.core.group.ModifiableGroup;
import org.ametys.core.group.directory.GroupDirectory;
import org.ametys.core.group.directory.ModifiableGroupDirectory;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.user.UserHelper;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class GroupDAO
extends AbstractLogEnabled
implements Serviceable,
Component {
    protected ServiceManager _smanager;
    protected CurrentUserProvider _currentUserProvider;
    protected GroupManager _groupManager;
    protected GroupDirectoryDAO _groupDirectoryDAO;
    protected UserHelper _userHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        this._smanager = smanager;
        this._groupManager = (GroupManager)smanager.lookup(GroupManager.ROLE);
        this._groupDirectoryDAO = (GroupDirectoryDAO)smanager.lookup(GroupDirectoryDAO.ROLE);
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
    }

    @Callable
    public Map<String, Object> addGroup(String groupDirectoryId, String name) throws InvalidModificationException {
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
        if (!(groupDirectory instanceof ModifiableGroupDirectory)) {
            this.getLogger().error("Groups are not modifiable !");
            throw new InvalidModificationException("Groups are not modifiable !");
        }
        ModifiableGroupDirectory modifiableGroupDirectory = (ModifiableGroupDirectory)groupDirectory;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Starting group creation");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("The new group name cannot be empty");
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(String.format("User %s is adding a new group '%s'", this._getCurrentUser(), name));
        }
        ModifiableGroup group = modifiableGroupDirectory.add(name);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Ending group creation");
        }
        return this.group2Json(group);
    }

    @Callable
    public Map<String, Object> setUsersGroup(String groupDirectoryId, String groupId, List<Map<String, String>> users) throws InvalidModificationException {
        ModifiableGroup group;
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
        if (!(groupDirectory instanceof ModifiableGroupDirectory)) {
            this.getLogger().error("Groups are not modifiable !");
            throw new InvalidModificationException("Groups are not modifiable !");
        }
        ModifiableGroupDirectory modifiableGroupDirectory = (ModifiableGroupDirectory)groupDirectory;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Starting group modification");
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(String.format("User %s is editing the group '%s'", this._getCurrentUser(), groupId));
        }
        if ((group = modifiableGroupDirectory.getGroup(groupId)) == null) {
            this.getLogger().warn(String.format("User %s tries to edit the group '%s' but the group does not exist.", this._getCurrentUser(), groupId));
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", "unknown-group");
            return result;
        }
        group.removeUsers();
        for (Map<String, String> user : users) {
            UserIdentity userIdentity = this._userHelper.json2userIdentity(user);
            if (userIdentity == null) continue;
            group.addUser(userIdentity);
        }
        modifiableGroupDirectory.update(group);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Ending group modification");
        }
        return this.group2Json(group);
    }

    @Callable
    public Map<String, Object> addUsersGroup(String groupDirectoryId, String groupId, List<Map<String, String>> users) throws InvalidModificationException {
        return this._updateUsersGroup(groupDirectoryId, groupId, users, false);
    }

    @Callable
    public Map<String, Object> removeUsersGroup(String groupDirectoryId, String groupId, List<Map<String, String>> users) throws InvalidModificationException {
        return this._updateUsersGroup(groupDirectoryId, groupId, users, true);
    }

    private Map<String, Object> _updateUsersGroup(String groupDirectoryId, String groupId, List<Map<String, String>> users, boolean remove) throws InvalidModificationException {
        ModifiableGroup group;
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
        if (!(groupDirectory instanceof ModifiableGroupDirectory)) {
            this.getLogger().error("Groups are not modifiable !");
            throw new InvalidModificationException("Groups are not modifiable !");
        }
        ModifiableGroupDirectory modifiableGroupDirectory = (ModifiableGroupDirectory)groupDirectory;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Starting group modification");
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(String.format("User %s is editing the group '%s'", this._getCurrentUser(), groupId));
        }
        if ((group = modifiableGroupDirectory.getGroup(groupId)) == null) {
            this.getLogger().warn(String.format("User %s tries to edit the group '%s' but the group does not exist.", this._getCurrentUser(), groupId));
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", "unknown-group");
            return result;
        }
        for (Map<String, String> user : users) {
            UserIdentity userIdentity = this._userHelper.json2userIdentity(user);
            if (userIdentity == null) continue;
            if (remove) {
                group.removeUser(userIdentity);
                continue;
            }
            group.addUser(userIdentity);
        }
        modifiableGroupDirectory.update(group);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Ending group modification");
        }
        return this.group2Json(group);
    }

    @Callable
    public List<Map<String, Object>> getUsersGroup(Map<String, String> user) {
        ArrayList<Map<String, Object>> jsonifiedGroups = new ArrayList<Map<String, Object>>();
        UserIdentity userIdentity = this._userHelper.json2userIdentity(user);
        Set<GroupIdentity> userGroups = this._groupManager.getUserGroups(userIdentity);
        for (GroupIdentity userGroup : userGroups) {
            Group group;
            GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(userGroup.getDirectoryId());
            if (groupDirectory == null || (group = groupDirectory.getGroup(userGroup.getId())) == null) continue;
            Map<String, Object> jsonifiedGroup = this.group2Json(group);
            jsonifiedGroups.add(jsonifiedGroup);
        }
        return jsonifiedGroups;
    }

    @Callable
    public Map<String, Object> renameGroup(String groupDirectoryId, String groupId, String name) throws InvalidModificationException {
        ModifiableGroup group;
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
        if (!(groupDirectory instanceof ModifiableGroupDirectory)) {
            this.getLogger().error("Groups are not modifiable !");
            throw new InvalidModificationException("Groups are not modifiable !");
        }
        ModifiableGroupDirectory modifiableGroupDirectory = (ModifiableGroupDirectory)groupDirectory;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Starting group renaming");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("The new group name cannot be empty");
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(String.format("User %s is renaming the group '%s' to '%s'", this._getCurrentUser(), groupId, name));
        }
        if ((group = modifiableGroupDirectory.getGroup(groupId)) == null) {
            this.getLogger().warn(String.format("User %s tries to rename the group '%s' but the group does not exist.", this._getCurrentUser(), groupId));
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", "unknown-group");
            return result;
        }
        group.setLabel(name);
        modifiableGroupDirectory.update(group);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Ending group renaming");
        }
        return this.group2Json(group);
    }

    @Callable
    public void deleteGroups(String groupDirectoryId, List<String> groupIds) throws InvalidModificationException {
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
        if (!(groupDirectory instanceof ModifiableGroupDirectory)) {
            this.getLogger().error("Groups are not modifiable !");
            throw new InvalidModificationException("Groups are not modifiable !");
        }
        ModifiableGroupDirectory modifiableGroupDirectory = (ModifiableGroupDirectory)groupDirectory;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Starting group removal");
        }
        for (String groupId : groupIds) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info(String.format("User %s is is removing group '%s'", this._getCurrentUser(), groupId));
            }
            modifiableGroupDirectory.remove(groupId);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Ending group removal");
        }
    }

    @Callable
    public Map<String, Object> getGroup(String groupDirectoryId, String id) {
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
        Group group = groupDirectory.getGroup(id);
        if (group != null) {
            return this.group2Json(group);
        }
        return null;
    }

    @Callable
    public boolean isModifiable(String groupDirectoryId, String id) {
        return this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId) instanceof ModifiableGroupDirectory;
    }

    protected Map<String, Object> group2Json(Group group) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("id", group.getIdentity().getId());
        infos.put("label", group.getLabel());
        infos.put("groupDirectory", group.getIdentity().getDirectoryId());
        infos.put("groupDirectoryLabel", this._groupDirectoryDAO.getGroupDirectory(group.getIdentity().getDirectoryId()).getLabel());
        return infos;
    }

    protected UserIdentity _getCurrentUser() {
        if (this._currentUserProvider == null) {
            try {
                this._currentUserProvider = (CurrentUserProvider)this._smanager.lookup(CurrentUserProvider.ROLE);
            }
            catch (ServiceException e) {
                throw new IllegalStateException(e);
            }
        }
        return this._currentUserProvider.getUser();
    }
}

