/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.group;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.group.GroupDirectoryContextHelper;
import org.ametys.core.group.GroupDirectoryDAO;
import org.ametys.core.group.directory.GroupDirectory;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.StringUtils;

public class GroupSearchAction
extends ServiceableAction {
    private static final int _DEFAULT_COUNT_VALUE = 100;
    private static final int _DEFAULT_OFFSET_VALUE = 0;
    private GroupDirectoryDAO _groupDirectoryDAO;
    private GroupDirectoryContextHelper _directoryContextHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._groupDirectoryDAO = (GroupDirectoryDAO)smanager.lookup(GroupDirectoryDAO.ROLE);
        this._directoryContextHelper = (GroupDirectoryContextHelper)smanager.lookup(GroupDirectoryContextHelper.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map jsParameters = (Map)objectModel.get("parent-context");
        ArrayList<Map<String, Object>> groups = new ArrayList<Map<String, Object>>();
        List contexts = (List)jsParameters.get("contexts");
        if (contexts != null) {
            this._searchGroupsByContext(groups, jsParameters, source, parameters, contexts);
        } else {
            String groupDirectoryId = (String)jsParameters.get("groupDirectoryId");
            this._searchGroupsByDirectory(groups, jsParameters, source, parameters, groupDirectoryId);
        }
        HashMap<String, ArrayList<Map<String, Object>>> result = new HashMap<String, ArrayList<Map<String, Object>>>();
        result.put("groups", groups);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    protected Map<String, String> _getSearchParameters(String source) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pattern", source);
        return params;
    }

    private void _searchGroupsByContext(List<Map<String, Object>> groups, Map<String, Object> jsParameters, String source, Parameters parameters, List<String> contexts) {
        List groupIds = (List)jsParameters.get("id");
        if (groupIds != null) {
            for (String groupDirectoryId : this._directoryContextHelper.getGroupDirectoriesOnContexts(new HashSet<String>(contexts))) {
                for (String groupId : groupIds) {
                    this._addNonNullJsonGroup(groups, groupDirectoryId, groupId);
                }
            }
        } else if (jsParameters.get("value") != null) {
            String[] values;
            for (String value : values = ((String)jsParameters.get("value")).split(",")) {
                String groupId = StringUtils.substringBeforeLast((String)value, (String)"#");
                String groupDir = StringUtils.substringAfterLast((String)value, (String)"#");
                this._addNonNullJsonGroup(groups, groupDir, groupId);
            }
        } else {
            int count = parameters.getParameterAsInteger("limit", 100);
            if (count == -1) {
                count = Integer.MAX_VALUE;
            }
            int offset = parameters.getParameterAsInteger("start", 0);
            for (String groupDirectoryId : this._directoryContextHelper.getGroupDirectoriesOnContexts(new HashSet<String>(contexts))) {
                GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
                groups.addAll(groupDirectory.groups2JSON(count, offset, this._getSearchParameters(source), false));
            }
        }
    }

    private void _searchGroupsByDirectory(List<Map<String, Object>> groups, Map<String, Object> jsParameters, String source, Parameters parameters, String groupDirectoryId) {
        List groupIds = (List)jsParameters.get("id");
        if (groupIds != null) {
            for (String groupId : groupIds) {
                this._addNonNullJsonGroup(groups, groupDirectoryId, groupId);
            }
        } else {
            int count = parameters.getParameterAsInteger("limit", 100);
            if (count == -1) {
                count = Integer.MAX_VALUE;
            }
            int offset = parameters.getParameterAsInteger("start", 0);
            GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
            groups.addAll(groupDirectory.groups2JSON(count, offset, this._getSearchParameters(source), false));
        }
    }

    private void _addNonNullJsonGroup(List<Map<String, Object>> groups, String groupDirectoryId, String id) {
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
        if (groupDirectory != null) {
            if (groupDirectory.getGroup(id) != null) {
                groups.add(groupDirectory.group2JSON(id, false));
            } else {
                this.getLogger().warn(String.format("Group of id '%s' and group directory '%s' does not exist. It may have been removed. Thus, it will not be returned.", id, groupDirectoryId));
            }
        } else {
            this.getLogger().warn(String.format("Group directory of id '%s' does not exist. It may have been removed. Thus, its groups will not be returned.", groupDirectoryId));
        }
    }
}

