/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupManager;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.core.user.UserHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class UsersGroupAction
extends ServiceableAction {
    private static final int _DEFAULT_COUNT_VALUE = Integer.MAX_VALUE;
    private static final int _DEFAULT_OFFSET_VALUE = 0;
    private UserHelper _userHelper;
    private UserManager _userManager;
    private GroupManager _groupManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._groupManager = (GroupManager)smanager.lookup(GroupManager.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        ArrayList<Map<String, Object>> users = new ArrayList<Map<String, Object>>();
        Map jsParameters = (Map)objectModel.get("parent-context");
        String groupDirectoryId = (String)jsParameters.get("groupDirectoryId");
        int offset = parameters.getParameterAsInteger("limit", Integer.MAX_VALUE);
        if (offset == -1) {
            offset = Integer.MAX_VALUE;
        }
        int begin = parameters.getParameterAsInteger("start", 0);
        Group group = this._groupManager.getGroup(groupDirectoryId, source);
        if (group != null) {
            List<User> sortedUsers = this._getSortedUsers(group);
            Iterator<User> it = sortedUsers.iterator();
            for (int index = 0; it.hasNext() && index < begin + offset; ++index) {
                User user = it.next();
                if (index < begin) continue;
                users.add(this._userHelper.user2json(user, true));
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("users", users);
        result.put("group", source);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    private List<User> _getSortedUsers(Group group) {
        ArrayList<User> users = new ArrayList<User>();
        Set<UserIdentity> groupUsers = group.getUsers();
        for (UserIdentity identity : groupUsers) {
            String login = identity.getLogin();
            String populationId = identity.getPopulationId();
            User user = this._userManager.getUser(populationId, login);
            if (user == null) continue;
            users.add(user);
        }
        Collections.sort(users, new Comparator<User>(){

            @Override
            public int compare(User u1, User u2) {
                int compare = u1.getLastName().toLowerCase().compareTo(u2.getLastName().toLowerCase());
                return compare != 0 ? compare : u1.getFirstName().toLowerCase().compareTo(u2.getFirstName().toLowerCase());
            }
        });
        return users;
    }
}

