/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.checker;

import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.ametys.runtime.model.checker.ItemChecker;
import org.ametys.runtime.model.checker.ItemCheckerTestFailureException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

public class LDAPConnectionChecker
extends AbstractLogEnabled
implements ItemChecker {
    @Override
    public void check(List<String> values) throws ItemCheckerTestFailureException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        String baseUrl = values.get(0);
        String authMethod = values.get(1);
        String adminDN = values.get(2);
        String adminPassword = values.get(3);
        String useSSL = values.get(4);
        String followReferrals = values.get(5);
        String baseDN = values.get(6);
        env.put("java.naming.provider.url", baseUrl);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", authMethod);
        if (authMethod.equals("simple")) {
            env.put("java.naming.security.principal", adminDN);
            env.put("java.naming.security.credentials", adminPassword);
        }
        if (useSSL.equals("true")) {
            env.put("java.naming.security.protocol", "ssl");
        }
        if (followReferrals.equals("true")) {
            env.put("java.naming.referral", "follow");
        }
        InitialDirContext context = null;
        try {
            context = new InitialDirContext(env);
            context.search(baseDN, null);
        }
        catch (NamingException e) {
            throw new ItemCheckerTestFailureException(e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    this.getLogger().error("Closing the LDAP connection during test failed.", (Throwable)e);
                }
            }
        }
    }
}

