/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.checker;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.ametys.core.datasource.AbstractDataSourceManager;
import org.ametys.core.datasource.LDAPDataSourceManager;
import org.ametys.core.util.ldap.ScopeEnumerator;
import org.ametys.runtime.model.checker.ItemChecker;
import org.ametys.runtime.model.checker.ItemCheckerTestFailureException;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class LdapUserDirectoryChecker
extends AbstractLogEnabled
implements ItemChecker,
Serviceable {
    private ServiceManager _manager;
    private LDAPDataSourceManager _ldapDataSourceManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void check(List<String> values) throws ItemCheckerTestFailureException {
        if (this._ldapDataSourceManager == null) {
            try {
                this._ldapDataSourceManager = (LDAPDataSourceManager)this._manager.lookup(LDAPDataSourceManager.ROLE);
            }
            catch (ServiceException e) {
                throw new ItemCheckerTestFailureException("The test cannot be tested now", e);
            }
        }
        String datasourceId = values.get(0);
        String usersRelativeDN = values.get(1);
        String usersObjectFilter = values.get(2);
        int usersSearchScope = ScopeEnumerator.parseScope(values.get(3));
        String usersLoginAttribute = values.get(4);
        String usersFirstnameAttribute = values.get(5);
        if (usersFirstnameAttribute != null && usersFirstnameAttribute.length() == 0) {
            usersFirstnameAttribute = null;
        }
        String usersLastnameAttribute = values.get(6);
        String usersEmailAttribute = values.get(7);
        boolean userEmailIsMandatory = "true".equals(values.get(8));
        AbstractDataSourceManager.DataSourceDefinition ldapDefinition = this._ldapDataSourceManager.getDataSourceDefinition(datasourceId);
        if (ldapDefinition == null) {
            throw new ItemCheckerTestFailureException("Unable to find the data source definition for the id '" + datasourceId + "'.");
        }
        InitialLdapContext context = null;
        NamingEnumeration<SearchResult> results = null;
        try {
            context = new InitialLdapContext(this._getContextEnv(ldapDefinition), null);
            results = context.search(usersRelativeDN, usersObjectFilter, new Object[0], this._getSearchConstraint(0, usersFirstnameAttribute, usersLoginAttribute, usersLastnameAttribute, usersEmailAttribute, usersSearchScope));
            boolean userFound = false;
            while (results.hasMoreElements() && !userFound) {
                SearchResult result = (SearchResult)results.nextElement();
                Map<String, Object> attrs = this._getAttributes(result, usersLoginAttribute, usersFirstnameAttribute, usersLastnameAttribute, usersEmailAttribute, userEmailIsMandatory);
                if (attrs == null) continue;
                userFound = true;
            }
            if (!userFound) {
                throw new ItemCheckerTestFailureException("The LDAP repository does not return any user with the given parameters.");
            }
        }
        catch (IllegalArgumentException | NamingException e) {
            try {
                throw new ItemCheckerTestFailureException(e);
            }
            catch (Throwable throwable) {
                try {
                    this._cleanup(context, results);
                    throw throwable;
                }
                catch (NamingException e2) {
                    this.getLogger().error("Cleaning the LDAP connection during test failed.", (Throwable)e2);
                    throw new ItemCheckerTestFailureException(e2);
                }
            }
        }
        try {
            this._cleanup(context, results);
            return;
        }
        catch (NamingException e) {
            this.getLogger().error("Cleaning the LDAP connection during test failed.", (Throwable)e);
            throw new ItemCheckerTestFailureException(e);
        }
    }

    private Hashtable<String, String> _getContextEnv(AbstractDataSourceManager.DataSourceDefinition ldapDefinition) {
        Map<String, Object> ldapParameters = ldapDefinition.getParameters();
        String ldapUrl = (String)ldapParameters.get("baseURL");
        String ldapBaseDN = (String)ldapParameters.get("baseDN");
        String ldapAdminRelativeDN = (String)ldapParameters.get("adminDN");
        String ldapAdminPassword = (String)ldapParameters.get("adminPassword");
        String ldapAuthenticationMethod = (String)ldapParameters.get("authenticationMethod");
        boolean ldapUseSSL = (Boolean)ldapParameters.get("useSSL");
        boolean ldapFollowReferrals = (Boolean)ldapParameters.get("followReferrals");
        String ldapAliasDerefMode = (String)ldapParameters.get("aliasDereferencing");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapUrl + "/" + ldapBaseDN);
        env.put("java.naming.security.authentication", ldapAuthenticationMethod);
        if (!ldapAuthenticationMethod.equals("none")) {
            env.put("java.naming.security.principal", ldapAdminRelativeDN);
            env.put("java.naming.security.credentials", ldapAdminPassword);
        }
        if (ldapUseSSL) {
            env.put("java.naming.security.protocol", "ssl");
        }
        if (ldapFollowReferrals) {
            env.put("java.naming.referral", "follow");
        } else {
            env.put("java.naming.referral", "ignore");
        }
        env.put("java.naming.ldap.derefAliases", ldapAliasDerefMode);
        env.put("com.sun.jndi.ldap.connect.pool", "true");
        return env;
    }

    private SearchControls _getSearchConstraint(int maxResults, String usersFirstnameAttribute, String usersLoginAttribute, String usersLastnameAttribute, String usersEmailAttribute, int usersSearchScope) {
        SearchControls constraints = new SearchControls();
        int attributesCount = 4;
        int index = 0;
        if (usersFirstnameAttribute == null) {
            --attributesCount;
        }
        String[] attrs = new String[attributesCount];
        attrs[index++] = usersLoginAttribute;
        if (usersFirstnameAttribute != null) {
            attrs[index++] = usersFirstnameAttribute;
        }
        attrs[index++] = usersLastnameAttribute;
        attrs[index++] = usersEmailAttribute;
        constraints.setReturningAttributes(attrs);
        constraints.setSearchScope(usersSearchScope);
        if (maxResults > 0) {
            constraints.setCountLimit(maxResults);
        }
        return constraints;
    }

    private Map<String, Object> _getAttributes(SearchResult entry, String usersLoginAttribute, String usersFirstnameAttribute, String usersLastnameAttribute, String usersEmailAttribute, boolean userEmailIsMandatory) throws NamingException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Attributes attrs = entry.getAttributes();
        Attribute ldapAttr = attrs.get(usersLoginAttribute);
        if (ldapAttr == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Missing login attribute : '{}'", (Object)usersLoginAttribute);
            }
            return null;
        }
        result.put(usersLoginAttribute, ldapAttr.get());
        if (usersFirstnameAttribute != null) {
            ldapAttr = attrs.get(usersFirstnameAttribute);
            if (ldapAttr == null) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Missing firstname attribute : '{}', for user '{}'.", (Object)usersFirstnameAttribute, result.get(usersLoginAttribute));
                }
                return null;
            }
            result.put(usersFirstnameAttribute, ldapAttr.get());
        }
        if ((ldapAttr = attrs.get(usersLastnameAttribute)) == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Missing lastname attribute : '{}', for user '{}'.", (Object)usersLastnameAttribute, result.get(usersLoginAttribute));
            }
            return null;
        }
        result.put(usersLastnameAttribute, ldapAttr.get());
        ldapAttr = attrs.get(usersEmailAttribute);
        if (ldapAttr == null && userEmailIsMandatory) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Missing email attribute : '{}', for user '{}'.", (Object)usersEmailAttribute, result.get(usersLoginAttribute));
            }
            return null;
        }
        if (ldapAttr == null) {
            result.put(usersEmailAttribute, "");
        } else {
            result.put(usersEmailAttribute, ldapAttr.get());
        }
        return result;
    }

    private void _cleanup(Context context, NamingEnumeration result) throws NamingException {
        if (result != null) {
            result.close();
        }
        if (context != null) {
            context.close();
        }
    }
}

