/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.checker;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.datasource.dbtype.SQLDatabaseTypeExtensionPoint;
import org.ametys.runtime.model.checker.ItemChecker;
import org.ametys.runtime.model.checker.ItemCheckerTestFailureException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class SQLConnectionChecker
extends AbstractLogEnabled
implements ItemChecker,
Serviceable {
    private ServiceManager _manager;

    public void service(ServiceManager manager) {
        this._manager = manager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void check(String url, String login, String password, ServiceManager manager) throws ItemCheckerTestFailureException {
        Connection connection = null;
        try {
            manager.lookup(SQLDatabaseTypeExtensionPoint.ROLE);
            connection = DriverManager.getConnection(url, login, password);
            if (connection == null) return;
        }
        catch (Exception e) {
            try {
                throw new ItemCheckerTestFailureException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                if (connection == null) throw throwable;
                try {
                    ConnectionHelper.cleanup(connection);
                    throw throwable;
                }
                catch (Exception e2) {
                    throw new ItemCheckerTestFailureException(e2.getMessage(), e2);
                }
            }
        }
        try {
            ConnectionHelper.cleanup(connection);
            return;
        }
        catch (Exception e) {
            throw new ItemCheckerTestFailureException(e.getMessage(), e);
        }
    }

    @Override
    public void check(List<String> values) throws ItemCheckerTestFailureException {
        String url = values.get(0);
        String login = values.get(1);
        String password = values.get(2);
        SQLConnectionChecker.check(url, login, password, this._manager);
    }
}

