/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.datasource;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.ametys.core.datasource.DataSourceConsumer;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.config.ConfigManager;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

public class ConfigurationDataSourceConsumer
extends AbstractLogEnabled
implements DataSourceConsumer {
    @Override
    public boolean isInUse(String id) {
        return this.getUsedDataSourceIds().contains(id);
    }

    @Override
    public Set<String> getUsedDataSourceIds() {
        HashSet<String> usedDataSourceIds = new HashSet<String>();
        Config config = Config.getInstance();
        if (config != null) {
            HashMap<String, Object> values = new HashMap();
            try {
                values = config.getValues();
            }
            catch (Exception e) {
                this.getLogger().error("Cannot read the configuration file.", (Throwable)e);
            }
            ConfigManager configManager = ConfigManager.getInstance();
            Collection<ElementDefinition> definitions = configManager.getConfigurationParameters();
            for (ElementDefinition definition : definitions) {
                if (!"datasource".equals(definition.getType().getId()) || configManager.evaluateDisableConditions(definition.getDisableConditions(), values)) continue;
                usedDataSourceIds.add((String)config.getValue(definition.getName()));
            }
        }
        return usedDataSourceIds;
    }
}

