/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.right;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.ProfileAssignmentStorageExtensionPoint;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractProfileStorageBasedAccessController
extends AbstractLogEnabled
implements AccessController,
Component,
Serviceable {
    protected static final UserIdentity __ANONYMOUS_USER_IDENTITY = null;
    protected static final UserIdentity __ANY_CONTECTED_USER_IDENTITY = new UserIdentity(null, null);
    protected ProfileAssignmentStorageExtensionPoint _profileAssignmentStorageEP;
    protected RightProfilesDAO _rightProfileDAO;
    protected RightManager _rightManager;
    private final String _cache1 = this.getClass().getName() + "$Cache-1";
    private final String _cache2 = this.getClass().getName() + "$Cache-2";

    public void service(ServiceManager manager) throws ServiceException {
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._rightProfileDAO = (RightProfilesDAO)manager.lookup(RightProfilesDAO.ROLE);
        this._profileAssignmentStorageEP = (ProfileAssignmentStorageExtensionPoint)manager.lookup(ProfileAssignmentStorageExtensionPoint.ROLE);
    }

    @Override
    public Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        HashMap<String, AccessController.AccessResult> rights = new HashMap<String, AccessController.AccessResult>();
        Map<String, AccessController.AccessResult> permissionsByProfile = this._profileAssignmentStorageEP.getPermissionsByProfile(user, userGroups, this._convertContext(object));
        for (String profileId : permissionsByProfile.keySet()) {
            List<String> rights2 = this._rightProfileDAO.getRights(profileId);
            for (String rightId : rights2) {
                rights.put(rightId, AccessController.AccessResult.merge(permissionsByProfile.get(profileId), (AccessController.AccessResult)((Object)rights.get(rightId))));
            }
        }
        return rights;
    }

    @Override
    public AccessController.AccessResult getPermission(UserIdentity user, Set<GroupIdentity> userGroups, String rightId, Object object) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        if (profilesIds == null || profilesIds.isEmpty()) {
            return AccessController.AccessResult.UNKNOWN;
        }
        Object convertedObject = this._convertContext(object);
        return this._getPermission(user, userGroups, profilesIds, object, convertedObject);
    }

    @Override
    public AccessController.AccessResult getReadAccessPermission(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        Set<String> profilesIds = Collections.singleton("READER");
        Object convertedObject = this._convertContext(object);
        return this._getPermission(user, userGroups, profilesIds, object, convertedObject);
    }

    protected AccessController.AccessResult _getPermission(UserIdentity user, Set<GroupIdentity> userGroups, Set<String> profilesIds, Object object, Object convertedObject) {
        Map cacheResult = (Map)this._hasRightResultInSecondCache(convertedObject, profilesIds, CacheKind.USER);
        if (cacheResult != null && cacheResult.containsKey(user)) {
            return (AccessController.AccessResult)((Object)cacheResult.get(user));
        }
        Map<String, AccessController.AccessResult> permissions = this._profileAssignmentStorageEP.getPermissions(user, userGroups, profilesIds, convertedObject);
        AccessController.AccessResult result = AccessController.AccessResult.merge(permissions.values());
        cacheResult = cacheResult == null ? new HashMap() : cacheResult;
        cacheResult.put(user, result);
        this._putInSecondCache(profilesIds, convertedObject, cacheResult, CacheKind.USER);
        return result;
    }

    @Override
    public AccessController.AccessResult getPermissionForAnonymous(String rightId, Object object) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        if (profilesIds == null || profilesIds.isEmpty()) {
            return AccessController.AccessResult.UNKNOWN;
        }
        Object convertedObject = this._convertContext(object);
        return this._getPermissionForAnonymous(profilesIds, object, convertedObject);
    }

    @Override
    public AccessController.AccessResult getReadAccessPermissionForAnonymous(Object object) {
        Set<String> profilesIds = Collections.singleton("READER");
        Object convertedObject = this._convertContext(object);
        return this._getPermissionForAnonymous(profilesIds, object, convertedObject);
    }

    protected AccessController.AccessResult _getPermissionForAnonymous(Set<String> profilesIds, Object object, Object convertedObject) {
        AccessController.AccessResult cacheResult = (AccessController.AccessResult)((Object)this._hasRightResultInSecondCache(convertedObject, profilesIds, CacheKind.ANONYMOUS));
        if (cacheResult != null) {
            return cacheResult;
        }
        AccessController.AccessResult result = this._profileAssignmentStorageEP.getPermissionForAnonymous(profilesIds, convertedObject);
        this._putInSecondCache(profilesIds, convertedObject, (Object)result, CacheKind.ANONYMOUS);
        return result;
    }

    @Override
    public AccessController.AccessResult getPermissionForAnyConnectedUser(String rightId, Object object) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        if (profilesIds == null || profilesIds.isEmpty()) {
            return AccessController.AccessResult.UNKNOWN;
        }
        Object convertedObject = this._convertContext(object);
        return this._getPermissionForAnyConnectedUser(profilesIds, object, convertedObject);
    }

    @Override
    public AccessController.AccessResult getReadAccessPermissionForAnyConnectedUser(Object object) {
        Set<String> profilesIds = Collections.singleton("READER");
        Object convertedObject = this._convertContext(object);
        return this._getPermissionForAnyConnectedUser(profilesIds, object, convertedObject);
    }

    protected AccessController.AccessResult _getPermissionForAnyConnectedUser(Set<String> profilesIds, Object object, Object convertedObject) {
        AccessController.AccessResult cacheResult = (AccessController.AccessResult)((Object)this._hasRightResultInSecondCache(convertedObject, profilesIds, CacheKind.ANY_CONNECTED_USER));
        if (cacheResult != null) {
            return cacheResult;
        }
        AccessController.AccessResult result = this._profileAssignmentStorageEP.getPermissionForAnyConnectedUser(profilesIds, convertedObject);
        this._putInSecondCache(profilesIds, convertedObject, (Object)result, CacheKind.ANY_CONNECTED_USER);
        return result;
    }

    @Override
    public Map<UserIdentity, AccessController.AccessResult> getPermissionByUser(String rightId, Object object) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        if (profilesIds == null || profilesIds.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        Object convertedObject = this._convertContext(object);
        return this._getPermissionByUser(profilesIds, object, convertedObject);
    }

    @Override
    public Map<UserIdentity, AccessController.AccessResult> getReadAccessPermissionByUser(Object object) {
        Set<String> profilesIds = Collections.singleton("READER");
        Object convertedObject = this._convertContext(object);
        return this._getPermissionByUser(profilesIds, object, convertedObject);
    }

    protected Map<UserIdentity, AccessController.AccessResult> _getPermissionByUser(Set<String> profilesIds, Object object, Object convertedObject) {
        Map cacheResult = (Map)this._hasRightResultInSecondCache(convertedObject, profilesIds, CacheKind.USERS);
        if (cacheResult != null) {
            return cacheResult;
        }
        Map<UserIdentity, AccessController.AccessResult> result = this._profileAssignmentStorageEP.getPermissionsByUser(profilesIds, convertedObject);
        this._putInSecondCache(profilesIds, convertedObject, result, CacheKind.USERS);
        return result;
    }

    @Override
    public Map<GroupIdentity, AccessController.AccessResult> getPermissionByGroup(String rightId, Object object) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        if (profilesIds == null || profilesIds.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        Object convertedObject = this._convertContext(object);
        return this._getPermissionByGroup(profilesIds, object, convertedObject);
    }

    @Override
    public Map<GroupIdentity, AccessController.AccessResult> getReadAccessPermissionByGroup(Object object) {
        Set<String> profilesIds = Collections.singleton("READER");
        Object convertedObject = this._convertContext(object);
        return this._getPermissionByGroup(profilesIds, object, convertedObject);
    }

    protected Map<GroupIdentity, AccessController.AccessResult> _getPermissionByGroup(Set<String> profilesIds, Object object, Object convertedObject) {
        Map cacheResult = (Map)this._hasRightResultInSecondCache(convertedObject, profilesIds, CacheKind.GROUPS);
        if (cacheResult != null) {
            return cacheResult;
        }
        Map<GroupIdentity, AccessController.AccessResult> result = this._profileAssignmentStorageEP.getPermissionsByGroup(profilesIds, convertedObject);
        this._putInSecondCache(profilesIds, convertedObject, result, CacheKind.GROUPS);
        return result;
    }

    protected Object _convertContext(Object initialContext) {
        return initialContext;
    }

    @Override
    public boolean hasAnonymousAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        Set<String> profilesIds = Collections.singleton("READER");
        return this._hasAnonymousAnyPermissionOnWorkspace(workspacesContexts, profilesIds);
    }

    @Override
    public boolean hasAnonymousAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        return this._hasAnonymousAnyPermissionOnWorkspace(workspacesContexts, profilesIds);
    }

    private boolean _hasAnonymousAnyPermissionOnWorkspace(Set<Object> workspacesContexts, Set<String> profilesIds) {
        Boolean cacheResult = this._hasRightResultInFirstCache(__ANONYMOUS_USER_IDENTITY, profilesIds, workspacesContexts);
        if (cacheResult != null) {
            return cacheResult;
        }
        Set<? extends Object> rootContexts = this._convertWorkspaceToRootRightContexts(workspacesContexts);
        boolean rightResult = CollectionUtils.isNotEmpty(rootContexts) ? this._profileAssignmentStorageEP.hasAnonymousAnyPermission(rootContexts, profilesIds) : false;
        this._putInFirstCache(__ANONYMOUS_USER_IDENTITY, profilesIds, workspacesContexts, rightResult);
        return rightResult;
    }

    @Override
    public boolean hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        Set<String> profilesIds = Collections.singleton("READER");
        return this._hasAnyConnectedUserAnyPermissionOnWorkspace(workspacesContexts, profilesIds);
    }

    @Override
    public boolean hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        return this._hasAnyConnectedUserAnyPermissionOnWorkspace(workspacesContexts, profilesIds);
    }

    private boolean _hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, Set<String> profilesIds) {
        Boolean cacheResult = this._hasRightResultInFirstCache(__ANY_CONTECTED_USER_IDENTITY, profilesIds, workspacesContexts);
        if (cacheResult != null) {
            return cacheResult;
        }
        Set<? extends Object> rootContexts = this._convertWorkspaceToRootRightContexts(workspacesContexts);
        boolean rightResult = CollectionUtils.isNotEmpty(rootContexts) ? this._profileAssignmentStorageEP.hasAnyConnectedUserAnyPermission(rootContexts, profilesIds) : false;
        this._putInFirstCache(__ANY_CONTECTED_USER_IDENTITY, profilesIds, workspacesContexts, rightResult);
        return rightResult;
    }

    @Override
    public boolean hasUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups) {
        Set<String> profilesIds = Collections.singleton("READER");
        return this._hasUserAnyPermissionOnWorkspace(workspacesContexts, user, userGroups, profilesIds);
    }

    @Override
    public boolean hasUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups, String rightId) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        return this._hasUserAnyPermissionOnWorkspace(workspacesContexts, user, userGroups, profilesIds);
    }

    private boolean _hasUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups, Set<String> profilesIds) {
        Boolean cacheResult = this._hasRightResultInFirstCache(user, profilesIds, workspacesContexts);
        if (cacheResult != null) {
            return cacheResult;
        }
        Set<? extends Object> rootContexts = this._convertWorkspaceToRootRightContexts(workspacesContexts);
        boolean rightResult = CollectionUtils.isNotEmpty(rootContexts) ? this._profileAssignmentStorageEP.hasUserAnyPermission(rootContexts, user, userGroups, profilesIds) : false;
        this._putInFirstCache(user, profilesIds, workspacesContexts, rightResult);
        return rightResult;
    }

    protected abstract Set<? extends Object> _convertWorkspaceToRootRightContexts(Set<Object> var1);

    protected Boolean _hasRightResultInFirstCache(UserIdentity userIdentity, Set<String> profilesIds, Object object) {
        if (profilesIds == null || profilesIds.isEmpty()) {
            return false;
        }
        Map mapCache = this._rightManager.getCache(this._cache1, false);
        if (mapCache != null && mapCache.containsKey(userIdentity)) {
            Map mapContext;
            int negativeProfiles = 0;
            Map mapProfile = (Map)mapCache.get(userIdentity);
            if (mapProfile.containsKey(profilesIds) && (mapContext = (Map)mapProfile.get(profilesIds)).containsKey(object)) {
                if (((Boolean)mapContext.get(object)).booleanValue()) {
                    this.getLogger().debug("Find entry in cache for [{}, {}, {}] => true", new Object[]{userIdentity, profilesIds, object});
                    return true;
                }
                ++negativeProfiles;
            }
            if (negativeProfiles == profilesIds.size()) {
                return false;
            }
        }
        this.getLogger().debug("Did not find entry in cache for [{}, {}, {}]", new Object[]{userIdentity, profilesIds, object});
        return null;
    }

    protected void _putInFirstCache(UserIdentity userIdentity, Set<String> profilesIds, Object object, boolean rightResult) {
        Map mapCache = this._rightManager.getCache(this._cache1, true);
        if (mapCache != null) {
            Map mapProfile;
            if (!mapCache.containsKey(userIdentity)) {
                mapCache.put(userIdentity, new HashMap());
            }
            if (!(mapProfile = (Map)mapCache.get(userIdentity)).containsKey(profilesIds)) {
                mapProfile.put(profilesIds, new HashMap());
            }
            Map mapContext = (Map)mapProfile.get(profilesIds);
            mapContext.put(object, rightResult);
        }
    }

    protected Object _hasRightResultInSecondCache(Object object, Set<String> profilesIds, CacheKind key) {
        Map mapResult;
        Object cacheResult;
        Map mapAll;
        Map mapCache = this._rightManager.getCache(this._cache2, false);
        if (mapCache != null && mapCache.containsKey(profilesIds) && (mapAll = (Map)mapCache.get(profilesIds)).containsKey(object) && (cacheResult = (mapResult = (Map)mapAll.get(object)).get((Object)key)) != null) {
            this.getLogger().debug("Find entry in cache for [{}, {}, {}] => {}", new Object[]{profilesIds, object, key, cacheResult});
            return cacheResult;
        }
        this.getLogger().debug("Did not find entry in cache for [{}, {}, {}]", new Object[]{profilesIds, object, key});
        return null;
    }

    protected void _putInSecondCache(Set<String> profilesIds, Object object, Object result, CacheKind key) {
        Map mapCache = this._rightManager.getCache(this._cache2, true);
        if (mapCache != null) {
            Map mapAll;
            if (!mapCache.containsKey(profilesIds)) {
                mapCache.put(profilesIds, new HashMap());
            }
            if (!(mapAll = (Map)mapCache.get(profilesIds)).containsKey(object)) {
                mapAll.put(object, new HashMap());
            }
            Map mapResult = (Map)mapAll.get(object);
            mapResult.put(key, result);
        }
    }

    protected static enum CacheKind {
        ANONYMOUS,
        ANY_CONNECTED_USER,
        USERS,
        USER,
        GROUPS;

    }
}

