/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.upload;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.ametys.core.upload.Upload;
import org.ametys.core.upload.UploadManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.environment.Context;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class FSUploadManager
extends TimerTask
implements UploadManager,
ThreadSafe,
Initializable,
Contextualizable,
LogEnabled,
Disposable {
    public static final String UPLOADS_DIRECTORY = "uploads-user";
    protected Context _context;
    protected File _globalUploadsDir;
    protected Timer _timer;
    private Logger _logger;

    public void enableLogging(Logger logger) {
        this._logger = logger;
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = (Context)context.get((Object)"environment-context");
    }

    public void initialize() throws Exception {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Starting timer");
        }
        this._globalUploadsDir = new File(AmetysHomeHelper.getAmetysHomeData(), UPLOADS_DIRECTORY);
        this._timer = new Timer("FSUploadManager", true);
        this._timer.scheduleAtFixedRate((TimerTask)this, 900000L, 86400000L);
    }

    @Override
    public void run() {
        if (this._logger.isInfoEnabled()) {
            this._logger.info("Time to clean old uploads");
        }
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            ((Calendar)calendar).add(6, -1);
            final long yesterday = calendar.getTimeInMillis();
            String[] loginDirs = this._globalUploadsDir.list((FilenameFilter)DirectoryFileFilter.INSTANCE);
            if (loginDirs != null) {
                for (String loginDir : loginDirs) {
                    File effectiveLoginDir = new File(this._globalUploadsDir, loginDir);
                    String[] dirsToRemove = effectiveLoginDir.list((FilenameFilter)new AbstractFileFilter(){

                        public boolean accept(File file) {
                            if (!file.isDirectory()) {
                                return false;
                            }
                            Collection uploadFiles = FileUtils.listFiles((File)file, (IOFileFilter)TrueFileFilter.INSTANCE, null);
                            if (uploadFiles.isEmpty()) {
                                return true;
                            }
                            File firstFile = (File)uploadFiles.iterator().next();
                            return firstFile.lastModified() < yesterday;
                        }
                    });
                    if (dirsToRemove == null) continue;
                    for (String dirToRemove : dirsToRemove) {
                        File uploadDir = new File(effectiveLoginDir, dirToRemove);
                        if (this._logger.isDebugEnabled()) {
                            this._logger.debug("Removing directory: " + uploadDir);
                        }
                        FileUtils.deleteDirectory((File)uploadDir);
                    }
                }
            }
        }
        catch (Exception e) {
            this._logger.error("Unable to clean old uploads", (Throwable)e);
        }
    }

    @Override
    public Upload storeUpload(UserIdentity user, String filename, InputStream is) throws IOException {
        if (!this._globalUploadsDir.exists() && !this._globalUploadsDir.mkdirs()) {
            throw new IOException("Unable to create directory: " + this._globalUploadsDir);
        }
        String id = UUID.randomUUID().toString();
        File uploadFile = null;
        try {
            uploadFile = new File(this._getUploadDir(user != null ? UserIdentity.userIdentityToString(user) : null, id), URLEncoder.encode(filename, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding", e);
        }
        if (this._logger.isInfoEnabled()) {
            this._logger.info("Using file: " + uploadFile);
        }
        if (!uploadFile.getParentFile().mkdirs()) {
            throw new IOException("Unable to create directory: " + uploadFile.getParent());
        }
        try (FileOutputStream os = new FileOutputStream(uploadFile);){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        return new FSUpload(this._context, uploadFile);
    }

    @Override
    public Upload getUpload(UserIdentity user, String id) throws NoSuchElementException {
        File uploadDir = this._getUploadDir(user != null ? UserIdentity.userIdentityToString(user) : null, id);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Using directory: " + uploadDir);
        }
        if (!uploadDir.exists() || !uploadDir.isDirectory()) {
            throw new NoSuchElementException("No directory: " + uploadDir);
        }
        Collection files = FileUtils.listFiles((File)uploadDir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)FalseFileFilter.INSTANCE);
        if (this._logger.isInfoEnabled()) {
            this._logger.info("Found files: " + files);
        }
        if (files.isEmpty()) {
            throw new NoSuchElementException("No files in directory: " + uploadDir);
        }
        return new FSUpload(this._context, (File)files.iterator().next());
    }

    public void dispose() {
        this.cancel();
        this._timer.cancel();
        this._globalUploadsDir = null;
        this._logger = null;
    }

    protected File _getUploadDir(String login, String id) {
        try {
            String fileName = login != null ? URLEncoder.encode(login, "UTF-8") : "_Anonymous";
            return new File(new File(this._globalUploadsDir, fileName), id);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding", e);
        }
    }

    protected static class FSUpload
    implements Upload {
        private Context _context;
        private File _file;

        public FSUpload(Context context, File file) {
            this._context = context;
            this._file = file;
        }

        @Override
        public String getId() {
            return this._file.getParentFile().getName();
        }

        @Override
        public Date getUploadedDate() {
            return new Date(this._file.lastModified());
        }

        @Override
        public String getFilename() {
            try {
                return URLDecoder.decode(this._file.getName(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unsupported encoding", e);
            }
        }

        @Override
        public String getMimeType() {
            String mimeType = this._context.getMimeType(this.getFilename().toLowerCase());
            if (mimeType == null) {
                mimeType = "application/unknown";
            }
            return mimeType;
        }

        @Override
        public long getLength() {
            return this._file.length();
        }

        @Override
        public InputStream getInputStream() {
            try {
                return new FileInputStream(this._file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Missing file: " + this._file, e);
            }
        }
    }
}

