/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.user;

import java.util.Map;
import org.ametys.core.authentication.AuthenticateAction;
import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.authentication.LogoutCapable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;

public class AvalonCurrentUserProvider
extends AbstractLogEnabled
implements CurrentUserProvider,
Contextualizable,
ThreadSafe {
    protected Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public UserIdentity getUser() {
        UserIdentity user;
        block6: {
            user = null;
            try {
                Map objectModel = ContextHelper.getObjectModel((Context)this._context);
                Request request = ObjectModelHelper.getRequest((Map)objectModel);
                user = AuthenticateAction.getUserIdentityFromSession(request);
            }
            catch (Exception e) {
                if (!this.getLogger().isInfoEnabled()) break block6;
                this.getLogger().info("Unable to retrieve current authenticated user, fallback to default user", (Throwable)e);
            }
        }
        if (user == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("There is no current user");
            }
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Providing current user as: " + user);
        }
        return user;
    }

    @Override
    public void logout() throws ProcessingException {
        Map objectModel = ContextHelper.getObjectModel((Context)this._context);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Session session = request.getSession(false);
        if (session != null) {
            CredentialProvider cp = AuthenticateAction.getCredentialProviderFromSession(request);
            session.invalidate();
            if (cp instanceof LogoutCapable) {
                ((LogoutCapable)((Object)cp)).logout();
            }
        }
    }
}

