/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.right.profile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.group.InvalidModificationException;
import org.ametys.core.right.Profile;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.right.RightsException;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class ProfileDAO
extends AbstractLogEnabled
implements Serviceable,
Component {
    protected ServiceManager _smanager;
    protected CurrentUserProvider _currentUserProvider;
    protected RightManager _rightManager;
    protected RightProfilesDAO _profilesDAO;

    public void service(ServiceManager smanager) throws ServiceException {
        this._smanager = smanager;
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
        this._profilesDAO = (RightProfilesDAO)smanager.lookup(RightProfilesDAO.ROLE);
    }

    @Callable
    public Map<String, Object> getProfile(String id) throws ServiceException, InvalidModificationException {
        return this.getProfile(id, false);
    }

    @Callable
    public Map<String, Object> getProfile(String id, boolean withRights) throws ServiceException, InvalidModificationException {
        Profile profile = this._profilesDAO.getProfile(id);
        if (profile == null) {
            return null;
        }
        Map<String, Object> jsonProfile = profile.toJSON();
        if (withRights) {
            jsonProfile.put("rights", this._profilesDAO.getRights(profile));
        }
        return jsonProfile;
    }

    @Callable
    public Map<String, Object> addProfile(String name, String context) throws ServiceException, InvalidModificationException {
        this.getLogger().debug("Starting profile creation");
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("The profile name cannot be empty");
        }
        this.getLogger().info("User {} is adding a new profile '{}'", (Object)this._getCurrentUser(), (Object)name);
        Profile profile = this._profilesDAO.addProfile(name, context);
        this.getLogger().debug("Ending profile creation");
        return profile.toJSON();
    }

    @Callable
    public Map<String, Object> renameProfile(String id, String name) throws ServiceException, InvalidModificationException {
        this.getLogger().debug("Starting profile modification");
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("The profile new name cannot be empty");
        }
        this.getLogger().info("User {} is renaming the profile '{}' to '{}'", new Object[]{this._getCurrentUser(), id, name});
        Profile profile = this._profilesDAO.getProfile(id);
        if (profile == null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", "unknown-profile");
            return result;
        }
        this._profilesDAO.renameProfile(profile, name);
        this.getLogger().debug("Ending profile modification");
        return profile.toJSON();
    }

    @Callable
    public Map<String, Object> editProfileRights(String id, List<String> rights) throws ServiceException, InvalidModificationException {
        this.getLogger().debug("Starting profile modification");
        this.getLogger().info("User {} is edit rights of profile '{}'", (Object)this._getCurrentUser(), (Object)id);
        Profile profile = this._profilesDAO.getProfile(id);
        if (profile == null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", "unknown-profile");
            return result;
        }
        this._profilesDAO.updateRights(profile, rights);
        this.getLogger().debug("Ending profile modification");
        return profile.toJSON();
    }

    @Callable
    public void deleteProfiles(List<String> ids) throws InvalidModificationException, ServiceException {
        this.getLogger().debug("Starting profile removal");
        for (String id : ids) {
            if ("READER".equals(id)) {
                throw new RightsException("You cannot remove the system profile 'READER'");
            }
            this.getLogger().info("User {} is is removing profile '{}'", (Object)this._getCurrentUser(), (Object)id);
            Profile profile = this._profilesDAO.getProfile(id);
            if (profile != null) {
                this._profilesDAO.deleteProfile(profile);
                continue;
            }
            this.getLogger().info("User {} is trying to remove an unexisting profile '{}'", (Object)this._getCurrentUser(), (Object)id);
        }
        this.getLogger().debug("Ending profile removal");
    }

    protected UserIdentity _getCurrentUser() {
        if (this._currentUserProvider == null) {
            try {
                this._currentUserProvider = (CurrentUserProvider)this._smanager.lookup(CurrentUserProvider.ROLE);
            }
            catch (ServiceException e) {
                throw new IllegalStateException(e);
            }
        }
        return this._currentUserProvider.getUser();
    }
}

