/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.right.profile;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.ametys.core.right.Profile;
import org.ametys.core.right.Right;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.right.RightsExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ProfileRightsGenerator
extends ServiceableGenerator {
    private RightsExtensionPoint _rights;
    private RightProfilesDAO _profilesDAO;

    public void service(ServiceManager m) throws ServiceException {
        super.service(m);
        this._rights = (RightsExtensionPoint)m.lookup(RightsExtensionPoint.ROLE);
        this._profilesDAO = (RightProfilesDAO)m.lookup(RightProfilesDAO.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String id = request.getParameter("id");
        this.contentHandler.startDocument();
        if (StringUtils.isEmpty((String)id)) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"profiles");
            List<Profile> profiles = this._profilesDAO.getProfiles();
            for (Profile profile : profiles) {
                this._saxProfileRights(profile);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"profiles");
        } else {
            Profile profile = this._profilesDAO.getProfile(id);
            if (profile != null) {
                this._saxProfileRights(profile);
            } else {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"profile");
            }
        }
        this.contentHandler.endDocument();
    }

    private void _saxProfileRights(Profile profile) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addCDATAAttribute("id", profile.getId());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"profile", (Attributes)attr);
        List<String> rights = this._profilesDAO.getRights(profile);
        for (String rightId : rights) {
            Right right = this._rights.getExtension(rightId);
            if (right == null) continue;
            right.toSAX(this.contentHandler);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"profile");
    }
}

