/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.populations;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.directory.ModifiableUserDirectory;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class GetUserPopulationsAction
extends ServiceableAction {
    private UserPopulationDAO _userPopulationDAO;
    private PopulationContextHelper _populationContextHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._userPopulationDAO = (UserPopulationDAO)serviceManager.lookup(UserPopulationDAO.ROLE);
        this._populationContextHelper = (PopulationContextHelper)this.manager.lookup(PopulationContextHelper.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        List<UserPopulation> populations;
        Boolean withAdmin;
        Map jsParameters = (Map)objectModel.get("parent-context");
        List contexts = (List)jsParameters.get("contexts");
        Boolean showDisabled = (Boolean)jsParameters.get("showDisabled");
        if (contexts == null && showDisabled == Boolean.TRUE) {
            withAdmin = Boolean.FALSE;
            if (jsParameters.get("withAdmin") != null) {
                withAdmin = (Boolean)jsParameters.get("withAdmin");
            }
            populations = this._userPopulationDAO.getUserPopulations(withAdmin);
        } else if (contexts == null) {
            withAdmin = Boolean.FALSE;
            if (jsParameters.get("withAdmin") != null) {
                withAdmin = (Boolean)jsParameters.get("withAdmin");
            }
            populations = this._userPopulationDAO.getEnabledUserPopulations(withAdmin);
        } else {
            Set<String> populationIds = this._populationContextHelper.getUserPopulationsOnContexts(contexts, false);
            populations = populationIds.stream().map(pId -> this._userPopulationDAO.getUserPopulation((String)pId)).collect(Collectors.toList());
        }
        Boolean modifiable = (Boolean)jsParameters.get("modifiable");
        if (modifiable == Boolean.TRUE) {
            populations = populations.stream().filter(up -> this.containsModifiableUserDirectory((UserPopulation)up)).collect(Collectors.toList());
        }
        HashMap result = new HashMap();
        List populationsAsJson = populations.stream().map(this._userPopulationDAO::getUserPopulationAsJson).collect(Collectors.toList());
        result.put("userPopulations", populationsAsJson);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    private boolean containsModifiableUserDirectory(UserPopulation up) {
        return up.getUserDirectories().stream().anyMatch(ud -> ud instanceof ModifiableUserDirectory);
    }
}

