/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.user;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.core.ui.user.ProfileImageProvider;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;

public class SafeProfileImageProvider
extends AbstractLogEnabled
implements ProfileImageProvider,
Serviceable {
    protected static final String __USER_PROFILES_DIR_PATH = "user-profiles";
    protected static final String __DEFAULT_FILE_NAME = "default.png";
    protected SourceResolver _sourceResolver;
    protected UserManager _userManager;

    public void service(ServiceManager smanager) throws ServiceException {
        this._sourceResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
    }

    @Override
    public ProfileImageProvider.UserProfileImage getImage(UserIdentity user, String imageSource, int size, int maxSize) throws ProcessingException {
        ProfileImageProvider.UserProfileImage image = this.getGravatarImage(user, size > 0 ? size : maxSize);
        if (image == null) {
            return this.getDefaultImage();
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProfileImageProvider.UserProfileImage getDefaultImage() {
        String location = "plugin:core-ui://resources/img/user-profiles/default.png";
        Source imgSource = null;
        try {
            imgSource = this._sourceResolver.resolveURI(location);
            if (imgSource.exists()) {
                ProfileImageProvider.UserProfileImage userProfileImage = new ProfileImageProvider.UserProfileImage(imgSource.getInputStream(), __DEFAULT_FILE_NAME, null);
                return userProfileImage;
            }
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Unable to find the default user image");
            }
        }
        catch (IOException e) {
            this.getLogger().error("Unable to retrieve the default user image");
        }
        finally {
            if (imgSource != null) {
                this._sourceResolver.release(imgSource);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProfileImageProvider.UserProfileImage getGravatarImage(UserIdentity user, int size) {
        Source httpSource = null;
        try {
            httpSource = this._getGravatarImageSource(user, size);
            if (httpSource != null && httpSource.exists()) {
                ProfileImageProvider.UserProfileImage userProfileImage = new ProfileImageProvider.UserProfileImage(httpSource.getInputStream());
                return userProfileImage;
            }
        }
        catch (IOException e) {
            this.getLogger().error("Unable to retrieve gravatar image for user '" + user + "'.", (Throwable)e);
        }
        finally {
            if (httpSource != null) {
                this._sourceResolver.release(httpSource);
            }
        }
        return null;
    }

    private Source _getGravatarImageSource(UserIdentity userIdentity, Integer size) throws IOException {
        User user = this._userManager.getUser(userIdentity.getPopulationId(), userIdentity.getLogin());
        if (user == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Unable to get gravatar image source - user not found " + userIdentity);
            }
            return null;
        }
        String email = user.getEmail();
        if (StringUtils.isEmpty((CharSequence)email)) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info(String.format("Unable to get gravatar image for user '%s' - an email is mandatory", userIdentity));
            }
            return null;
        }
        String hash = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(StandardCharsets.UTF_8.encode(email));
            byte[] hexBytes = new Hex(StandardCharsets.UTF_8).encode(md5.digest());
            hash = new String(hexBytes, StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException e) {
            this.getLogger().error("Cannot encode the user email to md5Base64", (Throwable)e);
            return null;
        }
        ArrayList<BasicNameValuePair> qparams = new ArrayList<BasicNameValuePair>(1);
        qparams.add(new BasicNameValuePair("d", "404"));
        if (size != null && size > 0) {
            qparams.add(new BasicNameValuePair("s", Integer.toString(size)));
        }
        String uri = new URIBuilder().setScheme("http").setHost("www.gravatar.com").setPath("/avatar/" + hash + ".png").setParameters(qparams).toString();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("Build gravatar uri for user '%s' : %s", userIdentity, uri));
        }
        return this._sourceResolver.resolveURI(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasGravatarImage(UserIdentity user) {
        Source httpSource = null;
        try {
            httpSource = this._getGravatarImageSource(user, null);
            boolean bl = httpSource != null && httpSource.exists();
            return bl;
        }
        catch (IOException e) {
            this.getLogger().error("Unable to test the gravatar image for user '" + user + "'.", (Throwable)e);
        }
        finally {
            if (httpSource != null) {
                this._sourceResolver.release(httpSource);
            }
        }
        return false;
    }
}

