/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.userpref;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreference;
import org.ametys.core.userpref.UserPreferencesErrors;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesExtensionPoint;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.cocoon.AbstractCurrentUserProviderServiceableAction;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.ParameterHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.StringUtils;

public class SetUserPreferencesAction
extends AbstractCurrentUserProviderServiceableAction {
    protected static final Set<DateFormat> _INPUT_DATE_FORMATS = new HashSet<DateFormat>();
    protected UserPreferencesExtensionPoint _userPrefEP;
    protected UserPreferencesManager _userPrefManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        if (this._userPrefEP == null) {
            this._userPrefEP = (UserPreferencesExtensionPoint)this.manager.lookup(UserPreferencesExtensionPoint.ROLE);
            this._userPrefManager = (UserPreferencesManager)((Object)this.manager.lookup(UserPreferencesManager.ROLE));
        }
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Map parentContext = (Map)objectModel.get("parent-context");
        String storageContext = this.getStorageContext(request, parameters);
        UserIdentity user = this.getUser(request, parameters);
        String submit = request.getParameter("submit");
        Map<Object, Object> results = new HashMap();
        if ("true".equals(submit)) {
            Collection<String> preferenceIds = this.getPreferenceIds(request, parentContext);
            Map<String, String> contextVars = this.getContextVars(request);
            results = this.setUserPreferences(request, storageContext, contextVars, user, preferenceIds);
        }
        return results;
    }

    protected UserIdentity getUser(Request request, Parameters parameters) {
        String username = parameters.getParameter("username", "");
        String userPopulation = parameters.getParameter("userpopulation", "");
        UserIdentity user = StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)userPopulation) ? this._getCurrentUser() : new UserIdentity(username, userPopulation);
        return user;
    }

    protected String getStorageContext(Request request, Parameters parameters) {
        return parameters.getParameter("prefContext", request.getParameter("prefContext"));
    }

    protected Map<String, String> setUserPreferences(Request request, String storageContext, Map<String, String> contextVars, UserIdentity user) throws UserPreferencesException {
        return this.setUserPreferences(request, storageContext, contextVars, user, Collections.emptySet());
    }

    protected Map<String, String> setUserPreferences(Request request, String storageContext, Map<String, String> contextVars, UserIdentity user, Collection<String> preferenceIds) throws UserPreferencesException {
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("status", "error");
        Map<String, String> values = this._userPrefManager.getUnTypedUserPrefs(user, storageContext, contextVars);
        UserPreferencesErrors errors = new UserPreferencesErrors();
        values.putAll(this._getValues(request, contextVars, user, preferenceIds, errors));
        this._userPrefEP.validatePreferences(contextVars, values, errors);
        if (!errors.hasErrors()) {
            this._userPrefManager.setUserPreferences(user, storageContext, contextVars, values);
            results.put("status", "success");
        } else {
            request.setAttribute("user-prefs-errors", (Object)errors);
        }
        return results;
    }

    protected Map<String, String> _getValues(Request request, Map<String, String> contextVars, UserIdentity user, Collection<String> preferenceIds, UserPreferencesErrors errors) {
        HashMap<String, String> preferences = new HashMap<String, String>();
        for (UserPreference preference : this._userPrefEP.getUserPreferences(contextVars).values()) {
            String value;
            String id = preference.getId();
            if (preference.getType() == ParameterHelper.ParameterType.DATE) {
                value = request.getParameter(id);
                if (value == null) continue;
                if (StringUtils.isBlank((String)value)) {
                    preferences.put(id, value);
                    continue;
                }
                Date date = this._parseDate(value);
                if (date == null) continue;
                preferences.put(id, ParameterHelper.valueToString(date));
                continue;
            }
            if (preference.getType() == ParameterHelper.ParameterType.PASSWORD) {
                value = request.getParameter(id);
                if (!StringUtils.isNotBlank((String)value)) continue;
                String confirmationValue = request.getParameter(id + "-confirmation");
                if (!value.equals(confirmationValue)) {
                    errors.addError(id, new I18nizableText("plugin.core", "PLUGINS_CORE_UI_USER_PREFERENCES_PWD_CONFIRMATION_DOESNT_MATCH"));
                }
                preferences.put(id, value);
                continue;
            }
            if (preference.getType() == ParameterHelper.ParameterType.BOOLEAN && preferenceIds.contains(id)) {
                value = request.getParameter(id);
                String valueStr = String.valueOf("true".equals(value));
                preferences.put(id, valueStr);
                continue;
            }
            Object[] values = request.getParameterValues(id);
            if (values == null) continue;
            String valuesStr = StringUtils.join((Object[])values, (char)',');
            preferences.put(id, valuesStr);
        }
        return preferences;
    }

    protected Date _parseDate(String value) {
        Date date = null;
        for (DateFormat format : _INPUT_DATE_FORMATS) {
            try {
                date = format.parse(value);
                return date;
            }
            catch (ParseException parseException) {
            }
        }
        return date;
    }

    protected Map<String, String> getContextVars(Request request) {
        HashMap<String, String> contextVars = new HashMap<String, String>();
        contextVars.put("workspace", (String)request.getAttribute("workspaceName"));
        return contextVars;
    }

    protected Collection<String> getPreferenceIds(Request request, Map<String, Object> parentContext) {
        return Collections.emptySet();
    }

    static {
        _INPUT_DATE_FORMATS.add(new SimpleDateFormat("yyyy-MM-dd"));
        _INPUT_DATE_FORMATS.add(new SimpleDateFormat("dd/MM/yyyy"));
    }
}

