/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.runtime.model.DefinitionAndValue;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.model.type.xml.XMLElementType;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Config {
    private static Logger __logger = LoggerFactory.getLogger(Config.class);
    private static Config __config;
    private static boolean __initialized;
    private static String __filename;
    private static boolean __fileExists;
    private static long __lastModified;
    private static Model __model;
    private Map<String, DefinitionAndValue> _definitionAndValues;

    private Config() {
    }

    public static Config getInstance() {
        if (!__initialized) {
            return null;
        }
        if (__config == null) {
            try {
                __config = new Config();
                __config._load();
            }
            catch (Exception e) {
                __logger.warn("Exception creating Config, it won't be accessible.", (Throwable)e);
                return null;
            }
        } else {
            __config._reloadIfNeeded();
        }
        return __config;
    }

    public static void setModel(Model model) {
        __model = model;
    }

    private void _load() throws Exception {
        __logger.info("Loading configuration values from file {}.", (Object)__filename);
        this._definitionAndValues = Config.__read();
    }

    private void _reloadIfNeeded() {
        if (__fileExists && new File(__filename).exists() && __lastModified < new File(__filename).lastModified()) {
            try {
                __logger.info("The config file has changed. Let's reload.");
                this._load();
            }
            catch (Exception e) {
                __logger.error("The config file '" + __filename + "' was modified but could not be reloaded due to an exception", (Throwable)e);
            }
        }
    }

    static Map<String, DefinitionAndValue> __read() throws Exception {
        HashMap<String, DefinitionAndValue> definitionAndValues = new HashMap<String, DefinitionAndValue>();
        File configFile = new File(__filename);
        __fileExists = configFile.exists();
        if (__fileExists) {
            __lastModified = configFile.lastModified();
            Configuration configuration = new DefaultConfigurationBuilder().buildFromFile(configFile);
            for (Configuration parameter : configuration.getChildren()) {
                String parameterName = parameter.getName();
                ModelItem modelItem = __model.getModelItem(parameterName);
                if (modelItem != null && modelItem instanceof ElementDefinition) {
                    ElementDefinition definition = (ElementDefinition)modelItem;
                    ElementType type = definition.getType();
                    if (!(type instanceof XMLElementType)) continue;
                    Object value = ((XMLElementType)type).read(configuration, parameterName);
                    DefinitionAndValue<Object> definitionAndValue = new DefinitionAndValue<Object>(null, definition, value);
                    definitionAndValues.put(parameterName, definitionAndValue);
                    continue;
                }
                __logger.warn("The parameter {} is not defined in configuration. This parameter is ignored.", (Object)parameterName);
            }
        } else {
            __lastModified = -1L;
        }
        return definitionAndValues;
    }

    public static void setInitialized(boolean initialized) {
        __initialized = initialized;
    }

    public static void setFilename(String filename) {
        __filename = filename;
        __fileExists = new File(__filename).exists();
    }

    public static boolean fileExists() {
        return __fileExists;
    }

    public Map<String, Object> getValues() {
        return Config.__extractValues(this._definitionAndValues);
    }

    static Map<String, Object> __extractValues(Map<String, DefinitionAndValue> definitionAndValues) {
        return DefinitionAndValue.extractValues(definitionAndValues);
    }

    public static Map<String, Object> getValuesAsJSONForClient() {
        Set<Map.Entry<String, DefinitionAndValue>> values;
        HashMap<String, Object> jsonValues = new HashMap<String, Object>();
        try {
            values = Config.__read().entrySet();
        }
        catch (Exception e) {
            __logger.warn("Config values are unreadable. Using default values", (Throwable)e);
            return jsonValues;
        }
        for (Map.Entry<String, DefinitionAndValue> entry : values) {
            DefinitionAndValue definitionAndValue = entry.getValue();
            Object value = definitionAndValue.getValue();
            ElementDefinition definition = (ElementDefinition)definitionAndValue.getDefinition();
            ElementType type = definition.getType();
            Object jsonValue = type.valueToJSONForClient(value);
            jsonValues.put(entry.getKey(), jsonValue);
        }
        return jsonValues;
    }

    public <T> T getValue(String name) {
        DefinitionAndValue definitionAndValue = this._definitionAndValues.get(name);
        if (definitionAndValue == null) {
            __logger.warn("The configuration parameter {} doesn't exist. A null value is retrieved.", (Object)name);
            return null;
        }
        return (T)definitionAndValue.getValue();
    }

    public <T> T getValue(String name, boolean useDefaultFromModel, T defaultValue) {
        DefinitionAndValue definitionAndValue = this._definitionAndValues.get(name);
        if (definitionAndValue == null) {
            __logger.warn("The configuration parameter {} doesn't exist. The given default value is retrieved.", (Object)name);
            return defaultValue;
        }
        Object value = definitionAndValue.getValue();
        if (value != null) {
            return (T)value;
        }
        if (useDefaultFromModel) {
            ElementDefinition definition = (ElementDefinition)definitionAndValue.getDefinition();
            Object defaultFromModel = definition.getDefaultValue();
            if (defaultFromModel != null) {
                return defaultFromModel;
            }
            __logger.debug("There is no default value in model for the configuration parameter {}. The given default value is retrieved.", (Object)name);
        }
        return defaultValue;
    }

    public static void dispose() {
        __config = null;
    }

    static {
        __lastModified = -1L;
    }
}

