/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.log;

import org.ametys.runtime.log.ExternalLog;
import org.ametys.runtime.log.MemoryAppender;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;

public class ExternalLogExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<ExternalLog> {
    public static final String ROLE = ExternalLogExtensionPoint.class.getName();

    @Override
    public void initializeExtensions() throws Exception {
        super.initializeExtensions();
        MemoryAppender memoryAppender = this._getMemoryAppender();
        for (String extensionId : this.getExtensionsIds()) {
            ExternalLog extension = (ExternalLog)this.getExtension(extensionId);
            Appender appender = extension.getAppender();
            Logger category = extension.getCategory();
            category.addAppender(appender);
            if (memoryAppender == null || category.getAdditivity()) continue;
            category.addAppender((Appender)memoryAppender);
        }
    }

    private MemoryAppender _getMemoryAppender() {
        Appender memoryAppender = Logger.getRootLogger().getAppender("memory-appender");
        if (memoryAppender != null && memoryAppender instanceof MemoryAppender) {
            return (MemoryAppender)memoryAppender;
        }
        return null;
    }
}

