/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.CategorizedElementDefinitionProxy;
import org.ametys.runtime.model.DefinitionAndValue;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.ModelViewItem;
import org.ametys.runtime.model.ModelViewItemGroup;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewElement;
import org.slf4j.Logger;

public final class CategorizedElementDefinitionHelper {
    private CategorizedElementDefinitionHelper() {
    }

    public static Map<String, ElementDefinition> getFlatDefinitions(Collection<CategorizedElementDefinitionProxy> elements) {
        HashMap<String, ElementDefinition> flatDefinitions = new HashMap<String, ElementDefinition>();
        for (CategorizedElementDefinitionProxy element : elements) {
            ElementDefinition definition = element.getDefinition();
            flatDefinitions.put(definition.getName(), definition);
        }
        return flatDefinitions;
    }

    public static List<ModelItem> categorize(Collection<CategorizedElementDefinitionProxy> elements) {
        Map<I18nizableText, Map<I18nizableText, List<CategorizedElementDefinitionProxy>>> categories = CategorizedElementDefinitionHelper.categorizeToMap(elements);
        ArrayList<ModelItem> modelItems = new ArrayList<ModelItem>();
        for (Map.Entry<I18nizableText, Map<I18nizableText, List<CategorizedElementDefinitionProxy>>> categoryEntry : categories.entrySet()) {
            ModelItemGroup category = new ModelItemGroup();
            category.setLabel(categoryEntry.getKey());
            modelItems.add(category);
            Map<I18nizableText, List<CategorizedElementDefinitionProxy>> values = categoryEntry.getValue();
            for (Map.Entry<I18nizableText, List<CategorizedElementDefinitionProxy>> groupEntry : values.entrySet()) {
                ModelItemGroup group = new ModelItemGroup();
                group.setLabel(groupEntry.getKey());
                category.addChild(group);
                Collection<CategorizedElementDefinitionProxy> orderedDefinitions = CategorizedElementDefinitionHelper.orderDefinitions((Collection<CategorizedElementDefinitionProxy>)groupEntry.getValue());
                for (CategorizedElementDefinitionProxy orderedDefinition : orderedDefinitions) {
                    ElementDefinition definition = orderedDefinition.getDefinition();
                    definition.setParent(group);
                    group.addChild(definition, orderedDefinition.isGroupSwitch());
                }
            }
        }
        return modelItems;
    }

    protected static Map<I18nizableText, Map<I18nizableText, List<CategorizedElementDefinitionProxy>>> categorizeToMap(Collection<CategorizedElementDefinitionProxy> elements) {
        HashMap<I18nizableText, Map<I18nizableText, List<CategorizedElementDefinitionProxy>>> categories = new HashMap<I18nizableText, Map<I18nizableText, List<CategorizedElementDefinitionProxy>>>();
        for (CategorizedElementDefinitionProxy parameter : elements) {
            ArrayList<CategorizedElementDefinitionProxy> group;
            I18nizableText displayCategory = parameter.getDisplayCategory();
            I18nizableText displayGroup = parameter.getDisplayGroup();
            HashMap<I18nizableText, ArrayList<CategorizedElementDefinitionProxy>> category = (HashMap<I18nizableText, ArrayList<CategorizedElementDefinitionProxy>>)categories.get(displayCategory);
            if (category == null) {
                category = new HashMap<I18nizableText, ArrayList<CategorizedElementDefinitionProxy>>();
                categories.put(displayCategory, category);
            }
            if ((group = (ArrayList<CategorizedElementDefinitionProxy>)category.get(displayGroup)) == null) {
                group = new ArrayList<CategorizedElementDefinitionProxy>();
                category.put(displayGroup, group);
            }
            group.add(parameter);
        }
        return categories;
    }

    protected static Collection<CategorizedElementDefinitionProxy> orderDefinitions(Collection<CategorizedElementDefinitionProxy> definitions) {
        return CategorizedElementDefinitionHelper.orderDefinitions(definitions, null, null);
    }

    protected static Collection<CategorizedElementDefinitionProxy> orderDefinitions(Collection<CategorizedElementDefinitionProxy> definitions, I18nizableText categoryLabel, I18nizableText groupLabel) {
        TreeSet<CategorizedElementDefinitionProxy> orderedParameters = new TreeSet<CategorizedElementDefinitionProxy>(new Comparator<CategorizedElementDefinitionProxy>(){

            @Override
            public int compare(CategorizedElementDefinitionProxy o1, CategorizedElementDefinitionProxy o2) {
                int positionComparison = Long.valueOf(o1.getPosition()).compareTo(o2.getPosition());
                if (o1.getPosition() < 0L && o2.getPosition() < 0L) {
                    positionComparison = 0;
                } else if (o1.getPosition() < 0L && o2.getPosition() >= 0L) {
                    positionComparison = 1;
                } else if (o2.getPosition() < 0L) {
                    positionComparison = -1;
                }
                if (positionComparison != 0) {
                    return positionComparison;
                }
                return o1.getDefinition().compareTo(o2.getDefinition());
            }
        });
        for (CategorizedElementDefinitionProxy parameterProxy : definitions) {
            boolean areCategoryAndGroupCoherent = true;
            if (categoryLabel != null) {
                areCategoryAndGroupCoherent &= categoryLabel.equals(parameterProxy.getDisplayCategory());
            }
            if (groupLabel != null) {
                areCategoryAndGroupCoherent &= groupLabel.equals(parameterProxy.getDisplayGroup());
            }
            if (!areCategoryAndGroupCoherent) continue;
            orderedParameters.add(parameterProxy);
        }
        return orderedParameters;
    }

    @Deprecated
    public static Map<String, List<I18nizableText>> validateValuesForWriting(Map<String, DefinitionAndValue> definitionAndValues, Map<String, ElementDefinition> flatDefinitions, Logger logger) {
        HashMap<String, List<I18nizableText>> errorFields = new HashMap<String, List<I18nizableText>>();
        for (ElementDefinition definition : flatDefinitions.values()) {
            List<I18nizableText> errors;
            boolean isGroupSwitchOn = ModelHelper.isGroupSwitchOn(definition, DefinitionAndValue.extractValues(definitionAndValues));
            boolean isDisabled = ModelHelper.evaluateDisableConditions(definition.getDisableConditions(), definitionAndValues, logger);
            if (!isGroupSwitchOn || isDisabled) continue;
            Object value = null;
            DefinitionAndValue definitionAndValue = definitionAndValues.get(definition.getName());
            if (definitionAndValue != null) {
                value = definitionAndValue.getValue();
            }
            if ((errors = ModelHelper.validateValue(definition, value)).isEmpty()) continue;
            logger.warn("The configuration parameter '{}' is not valid", (Object)definition.getName());
            errorFields.put(definition.getName(), errors);
        }
        if (!errorFields.isEmpty()) {
            logger.debug("Failed to save configuration because of invalid parameter values");
        }
        return errorFields;
    }

    public static Map<String, List<I18nizableText>> validateValuesForWriting(Map<String, DefinitionAndValue> definitionAndValues, Logger logger) {
        HashMap<String, List<I18nizableText>> errorFields = new HashMap<String, List<I18nizableText>>();
        for (Map.Entry<String, DefinitionAndValue> entry : definitionAndValues.entrySet()) {
            Object value;
            List<I18nizableText> errors;
            DefinitionAndValue definitionAndValue = entry.getValue();
            ModelItem definition = definitionAndValue.getDefinition();
            if (!(definition instanceof ElementDefinition)) continue;
            ElementDefinition elementDefinition = (ElementDefinition)definition;
            boolean isGroupSwitchOn = ModelHelper.isGroupSwitchOn(elementDefinition, DefinitionAndValue.extractValues(definitionAndValues));
            boolean isDisabled = ModelHelper.evaluateDisableConditions(elementDefinition.getDisableConditions(), definitionAndValues, logger);
            if (!isGroupSwitchOn || isDisabled || (errors = ModelHelper.validateValue(elementDefinition, value = definitionAndValue.getValue())).isEmpty()) continue;
            logger.warn("The configuration parameter '{}' is not valid", (Object)elementDefinition.getName());
            errorFields.put(elementDefinition.getName(), errors);
        }
        if (!errorFields.isEmpty()) {
            logger.debug("Failed to save configuration because of invalid parameter values");
        }
        return errorFields;
    }

    public static View buildViewFromCategories(Collection<? extends ModelItem> categories, Comparator<? super ModelItem> categoriesComparator, Comparator<? super ModelItem> groupsComparator) throws IllegalArgumentException {
        View view = new View();
        Collection<? extends ModelItem> sorted = CategorizedElementDefinitionHelper._sort(categories, categoriesComparator);
        for (ModelItem modelItem : sorted) {
            view.addViewItem(CategorizedElementDefinitionHelper._buildCategoryViewItem(modelItem, groupsComparator));
        }
        return view;
    }

    private static Collection<? extends ModelItem> _sort(Collection<? extends ModelItem> items, Comparator<? super ModelItem> comparator) {
        if (comparator == null) {
            return items;
        }
        ArrayList<? extends ModelItem> sorted = new ArrayList<ModelItem>(items);
        sorted.sort(comparator);
        return sorted;
    }

    private static ModelViewItemGroup _buildCategoryViewItem(ModelItem category, Comparator<? super ModelItem> groupsComparator) throws IllegalArgumentException {
        if (category instanceof ModelItemGroup) {
            ModelItemGroup modelGroup = (ModelItemGroup)category;
            ModelViewItemGroup categoryViewItem = new ModelViewItemGroup();
            categoryViewItem.setRole("tab");
            categoryViewItem.setDefinition(modelGroup);
            Collection<? extends ModelItem> groups = CategorizedElementDefinitionHelper._sort(modelGroup.getChildren(), groupsComparator);
            for (ModelItem modelItem : groups) {
                categoryViewItem.addViewItem(CategorizedElementDefinitionHelper._buildGroupViewItem(modelItem));
            }
            return categoryViewItem;
        }
        throw new IllegalArgumentException("Category " + category.getPath() + " should be an instance of ModelItemGroup");
    }

    private static ModelViewItemGroup _buildGroupViewItem(ModelItem modelItem) throws IllegalArgumentException {
        if (modelItem instanceof ModelItemGroup) {
            ModelItemGroup modelGroup = (ModelItemGroup)modelItem;
            ModelViewItemGroup groupViewItem = new ModelViewItemGroup();
            groupViewItem.setRole("fieldset");
            groupViewItem.setDefinition(modelGroup);
            List<ModelItem> items = modelGroup.getChildren();
            for (ModelItem item : items) {
                groupViewItem.addViewItem(CategorizedElementDefinitionHelper._buildElementViewItem(item));
            }
            return groupViewItem;
        }
        throw new IllegalArgumentException("Group " + modelItem.getPath() + " should be an instance of ModelItemGroup");
    }

    private static ModelViewItem _buildElementViewItem(ModelItem modelItem) throws IllegalArgumentException {
        if (modelItem instanceof ElementDefinition) {
            ElementDefinition definition = (ElementDefinition)modelItem;
            ViewElement parameterViewItem = new ViewElement();
            parameterViewItem.setDefinition(definition);
            return parameterViewItem;
        }
        throw new IllegalArgumentException("Item " + modelItem.getPath() + " should be an instance of ElementDefinition");
    }
}

