/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import org.ametys.runtime.model.CategorizedElementDefinitionProxy;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ElementDefinitionParser;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceManager;

public class CategorizedElementDefinitionParser
extends ElementDefinitionParser {
    public CategorizedElementDefinitionParser(AbstractThreadSafeComponentExtensionPoint<? extends ElementType> elementTypeExtensionPoint, ThreadSafeComponentManager<Enumerator> enumeratorManager, ThreadSafeComponentManager<Validator> validatorManager) {
        super(elementTypeExtensionPoint, enumeratorManager, validatorManager);
    }

    @Override
    public CategorizedElementDefinitionProxy parse(ServiceManager serviceManager, String pluginName, Configuration definitionConfig, Model model, ModelItemGroup parent) throws ConfigurationException {
        CategorizedElementDefinitionProxy elementDefinitionProxy = (CategorizedElementDefinitionProxy)super.parse(serviceManager, pluginName, definitionConfig, model, parent);
        elementDefinitionProxy.setDisplayCategory(this._parseI18nizableText(definitionConfig, pluginName, "category"));
        elementDefinitionProxy.setDisplayGroup(this._parseI18nizableText(definitionConfig, pluginName, "group"));
        elementDefinitionProxy.setPosition(definitionConfig.getChild("order").getValueAsLong(-1L));
        elementDefinitionProxy.setGroupSwitch(this._isGroupSwitch(definitionConfig));
        return elementDefinitionProxy;
    }

    @Override
    protected CategorizedElementDefinitionProxy _createModelItem(Configuration definitionConfig) throws ConfigurationException {
        return new CategorizedElementDefinitionProxy();
    }

    @Override
    protected Object _parseDefaultValue(Configuration definitionConfig, ElementDefinition definition) throws ConfigurationException {
        Object defaultValue = super._parseDefaultValue(definitionConfig, definition);
        if (this._isGroupSwitch(definitionConfig) && defaultValue == null) {
            return Boolean.FALSE;
        }
        return defaultValue;
    }

    private boolean _isGroupSwitch(Configuration definitionConfig) {
        return definitionConfig.getAttributeAsBoolean("group-switch", false);
    }
}

