/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.runtime.model.AbstractViewItemGroup;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.ModelViewItem;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.apache.cocoon.ProcessingException;

public class ModelViewItemGroup
extends AbstractViewItemGroup
implements ModelViewItem<ModelItemGroup> {
    private ModelItemGroup _definition;

    @Override
    public ModelItemGroup getDefinition() {
        return this._definition;
    }

    @Override
    public void setDefinition(ModelItemGroup definition) {
        if (definition == null) {
            throw new IllegalArgumentException("Try to set a null definition to the model view item group");
        }
        this._definition = definition;
    }

    @Override
    public String getName() {
        if (this._definition != null) {
            return this._definition.getName();
        }
        return null;
    }

    @Override
    public Map<String, Object> toJSON() throws ProcessingException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("role", this.getRole());
        if (!this._getChildrenForJSON().isEmpty()) {
            LinkedHashMap<String, Object> elements = new LinkedHashMap<String, Object>();
            ArrayList<Map<String, Object>> groups = new ArrayList<Map<String, Object>>();
            for (ViewItem item : this._getChildrenForJSON()) {
                if (item instanceof ViewElement) {
                    elements.putAll(item.toJSON());
                    continue;
                }
                groups.add(item.toJSON());
            }
            if (!groups.isEmpty()) {
                elements.put("groups", groups);
            }
            result.put("elements", elements);
        }
        if (this.getDefinition() != null) {
            result.putAll(this.getDefinition().toJSON(false));
        }
        return result;
    }

    private List<ViewItem> _getChildrenForJSON() {
        ElementDefinition<Boolean> switcher = this.getDefinition().getSwitcher();
        if (switcher == null) {
            return this.getViewItems();
        }
        ArrayList<ViewItem> childrenWithoutSwitcher = new ArrayList<ViewItem>();
        for (ViewItem child : this.getViewItems()) {
            ElementDefinition childDefinitonReference;
            if (!(child instanceof ViewElement) || switcher.equals(childDefinitonReference = ((ViewElement)child).getDefinition())) continue;
            childrenWithoutSwitcher.add(child);
        }
        return childrenWithoutSwitcher;
    }
}

