/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.AbstractViewItemGroup;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewHelper;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.util.ModifiableLabelable;
import org.apache.cocoon.ProcessingException;

public class SimpleViewItemGroup
extends AbstractViewItemGroup
implements ModifiableLabelable {
    private String _name;
    private I18nizableText _label;
    private I18nizableText _description;

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public void setLabel(I18nizableText label) {
        this._label = label;
    }

    @Override
    public I18nizableText getDescription() {
        return this._description;
    }

    @Override
    public void setDescription(I18nizableText description) {
        this._description = description;
    }

    @Override
    public Map<String, Object> toJSON() throws ProcessingException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("name", this.getName());
        result.put("label", this.getLabel());
        result.put("description", this.getDescription());
        result.put("role", this.getRole());
        if (!this.getViewItems().isEmpty()) {
            LinkedHashMap<String, Object> elements = new LinkedHashMap<String, Object>();
            ArrayList<Map<String, Object>> groups = new ArrayList<Map<String, Object>>();
            for (ViewItem item : this.getViewItems()) {
                if (item instanceof ViewElement) {
                    elements.putAll(item.toJSON());
                    continue;
                }
                groups.add(item.toJSON());
            }
            if (!groups.isEmpty()) {
                elements.put("groups", groups);
            }
            result.put("elements", elements);
        }
        return result;
    }

    public void includeView(View viewToInclude, View referenceView) {
        ViewHelper.addViewContainerItems(this, viewToInclude, referenceView);
    }

    public void copyGroupItem(SimpleViewItemGroup groupToCopy, View referenceView) {
        this.setRole(groupToCopy.getRole());
        this.setName(groupToCopy.getName());
        this.setLabel(groupToCopy.getLabel());
        this.setDescription(groupToCopy.getDescription());
        ViewHelper.addViewContainerItems(this, groupToCopy, referenceView);
    }
}

