/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.HashMap;
import java.util.Map;
import org.ametys.plugins.core.ui.help.HelpLink;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelViewItem;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.lang3.StringUtils;

public class ViewElement
implements ModelViewItem<ElementDefinition> {
    private ElementDefinition _definition;

    @Override
    public ElementDefinition getDefinition() {
        return this._definition;
    }

    @Override
    public void setDefinition(ElementDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException("Try to set a null definition to the view element");
        }
        this._definition = definition;
    }

    @Override
    public String getName() {
        if (this._definition != null) {
            return this._definition.getName();
        }
        return null;
    }

    @Override
    public Map<String, Object> toJSON() throws ProcessingException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.getDefinition() != null) {
            ElementDefinition definition = this.getDefinition();
            Map<String, Object> json = definition.toJSON();
            Model model = definition.getModel();
            if (model != null) {
                String modelId = model.getId();
                String family = model.getFamilyId();
                String path = definition.getPath();
                if (StringUtils.isNotBlank((CharSequence)path)) {
                    path = StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
                }
                String featureId = StringUtils.join((Object[])new String[]{modelId, path});
                featureId = StringUtils.removeStart((String)featureId, (String)"/");
                HelpLink help = new HelpLink(family, featureId, null);
                json.put("help", help);
            }
            result.put(definition.getName(), json);
        }
        return result;
    }
}

