/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.runtime.plugin.AbstractFeatureActivator;
import org.ametys.runtime.plugin.ComponentDefinition;
import org.ametys.runtime.plugin.ExtensionDefinition;
import org.ametys.runtime.plugin.ExtensionPointDefinition;
import org.ametys.runtime.plugin.Feature;
import org.ametys.runtime.plugin.FeatureActivator;
import org.ametys.runtime.plugin.Plugin;
import org.ametys.runtime.plugin.PluginIssue;
import org.ametys.runtime.plugin.PluginsManager;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ArrayUtils;

public final class IncludePolicyFeatureActivator
extends AbstractFeatureActivator {
    private static String[] __KERNEL_DEPENDENCIES_NEEDED = new String[]{"core/core.observation"};
    private Collection<IncludedFeature> _includedFeatures;

    public IncludePolicyFeatureActivator(Map<String, Plugin> allPlugins, Collection<IncludedFeature> includedFeatures) {
        super(allPlugins);
        this._includedFeatures = includedFeatures;
    }

    @Override
    public FeatureActivator.PluginsInformation computeActiveFeatures(Map<String, String> componentsConfig, boolean safeMode) {
        this._safeMode = safeMode;
        HashMap<String, Feature> initialFeatures = new HashMap<String, Feature>();
        HashMap<String, ExtensionPointDefinition> extensionPoints = new HashMap<String, ExtensionPointDefinition>();
        HashMap<String, PluginsManager.InactivityCause> inactiveFeatures = new HashMap<String, PluginsManager.InactivityCause>();
        ArrayList<PluginIssue> errors = new ArrayList<PluginIssue>();
        Map<String, Plugin> plugins = this.computeActivePlugins(Collections.emptySet(), initialFeatures, inactiveFeatures, extensionPoints, errors);
        this.removeWrongPointReferences(initialFeatures, inactiveFeatures, extensionPoints, errors);
        Map<String, Feature> activeFeatures = this.processOutgoingDependencies(initialFeatures, inactiveFeatures, errors);
        Map<String, Collection<String>> outgoingDependencies = this.computeOutgoingDependencies(activeFeatures);
        List<String> includedFeatures = this._getIncludedFeatures();
        Map<String, Collection<String>> incomingDeactivations = this.computeIncomingDeactivations(initialFeatures);
        List<String> dependencies = this._getDependencies(includedFeatures, outgoingDependencies);
        List includedFeaturesAndDependencies = ListUtils.union(includedFeatures, dependencies);
        this._removeUnusedFeatures(activeFeatures, inactiveFeatures, includedFeaturesAndDependencies);
        Map<String, Collection<String>> featuresToDeactivate = this._getFeaturesToDeactivate(incomingDeactivations, includedFeaturesAndDependencies);
        List<String> dependenciesNowUnused = this._computeDependenciesNowUnused(featuresToDeactivate.keySet(), outgoingDependencies, includedFeatures, activeFeatures);
        this._removeDeactivatedFeatures(activeFeatures, inactiveFeatures, featuresToDeactivate, dependenciesNowUnused);
        Map<String, Map<String, ExtensionDefinition>> extensions = this.computeExtensions(activeFeatures, errors);
        Map<String, ComponentDefinition> components = this.computeComponents(activeFeatures, componentsConfig, errors);
        return new FeatureActivator.PluginsInformation(plugins, activeFeatures, inactiveFeatures, extensionPoints, extensions, components, errors);
    }

    private List<String> _getIncludedFeatures() {
        return Stream.concat(Stream.of(__KERNEL_DEPENDENCIES_NEEDED), this._includedFeatures.stream().map(IncludedFeature::featureId)).collect(Collectors.toList());
    }

    private List<String> _getDependencies(List<String> featuresToProcess, Map<String, Collection<String>> outgoingDependencies) {
        ArrayList<String> dependencies = new ArrayList<String>();
        this._fillRecursiveDependencies(featuresToProcess, outgoingDependencies, dependencies, false);
        return dependencies;
    }

    private void _fillRecursiveDependencies(Collection<String> featuresToProcess, Map<String, Collection<String>> outgoingDependencies, List<String> dependencyListToFill, boolean addFeaturesToProcess) {
        for (String featureToProcess : featuresToProcess) {
            Collection<String> deps;
            if (addFeaturesToProcess) {
                dependencyListToFill.add(featureToProcess);
            }
            if ((deps = outgoingDependencies.get(featureToProcess)) == null) continue;
            this._fillRecursiveDependencies(deps, outgoingDependencies, dependencyListToFill, true);
        }
    }

    private void _removeUnusedFeatures(Map<String, Feature> activeFeatures, Map<String, PluginsManager.InactivityCause> inactiveFeatures, Collection<String> featuresToKeep) {
        Set<String> ids = activeFeatures.keySet();
        Iterator<String> it = ids.iterator();
        while (it.hasNext()) {
            String id = it.next();
            if (featuresToKeep.contains(id)) continue;
            this._logger.debug("Remove unused feature '{}'", (Object)id);
            it.remove();
            if (inactiveFeatures.containsKey(id)) continue;
            inactiveFeatures.put(id, PluginsManager.InactivityCause.UNUSED);
        }
    }

    private Map<String, Collection<String>> _getFeaturesToDeactivate(Map<String, Collection<String>> incomingDeactivations, List<String> includedFeatures) {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        for (String id : includedFeatures) {
            Collection<String> deactivatedBy;
            if (!incomingDeactivations.containsKey(id) || (deactivatedBy = incomingDeactivations.get(id)) == null || !CollectionUtils.containsAny(includedFeatures, deactivatedBy)) continue;
            result.put(id, CollectionUtils.intersection(includedFeatures, deactivatedBy));
        }
        return result;
    }

    private List<String> _computeDependenciesNowUnused(Collection<String> featuresToDeactivate, Map<String, Collection<String>> outgoingDependencies, List<String> includedFeatures, Map<String, Feature> allFeatures) {
        ArrayList<String> dependenciesNowUnused = new ArrayList<String>();
        Map<String, Collection<String>> incomingDependencies = this.computeIncomingDependencies(allFeatures);
        for (String featureToDeactivate : featuresToDeactivate) {
            Collection<String> dependencies = outgoingDependencies.get(featureToDeactivate);
            for (String dependency : dependencies) {
                Collection<String> incomingDependency = incomingDependencies.get(dependency);
                if (incomingDependency.size() != 1 || !incomingDependency.iterator().next().equals(featureToDeactivate) || includedFeatures.contains(dependency)) continue;
                dependenciesNowUnused.add(dependency);
            }
        }
        return dependenciesNowUnused;
    }

    private void _removeDeactivatedFeatures(Map<String, Feature> activeFeatures, Map<String, PluginsManager.InactivityCause> inactiveFeatures, Map<String, Collection<String>> featuresToDeactivate, List<String> dependenciesNowUnused) {
        Iterator<String> it = activeFeatures.keySet().iterator();
        while (it.hasNext()) {
            String id = it.next();
            if (featuresToDeactivate.containsKey(id)) {
                Collection<String> deactivatedBy = featuresToDeactivate.get(id);
                this._logger.debug("Remove feature {} deactivated by features {}", (Object)id, deactivatedBy);
                it.remove();
                inactiveFeatures.put(id, PluginsManager.InactivityCause.DEACTIVATED);
                continue;
            }
            if (!dependenciesNowUnused.contains(id)) continue;
            this._logger.debug("Remove unused dependency '{}'", (Object)id);
            it.remove();
            if (inactiveFeatures.containsKey(id)) continue;
            inactiveFeatures.put(id, PluginsManager.InactivityCause.UNUSED);
        }
    }

    @Override
    public String shortDump(FeatureActivator.PluginsInformation pluginInfo) {
        Collection<PluginIssue> errors = pluginInfo.getErrors();
        Map<String, PluginsManager.InactivityCause> inactiveFeatures = pluginInfo.getInactiveFeatures();
        Map<String, Collection<String>> dependencies = this.computeIncomingDependencies(pluginInfo.getFeatures());
        StringBuilder sb = new StringBuilder();
        String separator = new String(new char[30]).replace('\u0000', '-');
        sb.append(separator).append("\n");
        List pluginNames = this._allPlugins.keySet().stream().sorted().collect(Collectors.toList());
        for (String pluginName : pluginNames) {
            Plugin plugin = (Plugin)this._allPlugins.get(pluginName);
            this._dumpPlugin(sb, plugin, dependencies, inactiveFeatures);
        }
        if (!errors.isEmpty()) {
            sb.append("\nErrors :\n");
            errors.forEach(issue -> sb.append(issue.toString()).append('\n'));
        }
        sb.append(separator).append("\n");
        return sb.toString();
    }

    private void _dumpPlugin(StringBuilder sb, Plugin plugin, Map<String, Collection<String>> dependencies, Map<String, PluginsManager.InactivityCause> inactiveFeatures) {
        String pluginName = plugin.getName();
        sb.append("Plugin ").append(pluginName);
        sb.append("\n\n");
        Map<String, Feature> activeFeatures = plugin.getFeatures();
        List featureIds = activeFeatures.keySet().stream().sorted().collect(Collectors.toList());
        for (String featureId : featureIds) {
            Feature feature = activeFeatures.get(featureId);
            this._dumpFeature(sb, feature, dependencies, inactiveFeatures);
        }
        sb.append('\n');
    }

    private void _dumpFeature(StringBuilder sb, Feature feature, Map<String, Collection<String>> dependencies, Map<String, PluginsManager.InactivityCause> inactiveFeatures) {
        String featureId = feature.getFeatureId();
        if (!inactiveFeatures.containsKey(featureId)) {
            Optional<IncludedFeature> includedFeature;
            sb.append("  Feature ").append(featureId);
            ArrayList<String> dependenciesOfFeature = new ArrayList<String>();
            if (dependencies.containsKey(featureId)) {
                dependenciesOfFeature.addAll(dependencies.get(featureId));
            }
            if ((includedFeature = this._find(featureId)).isPresent()) {
                dependenciesOfFeature.add(0, "INCLUDED_FEATURE BY " + includedFeature.get().cause());
            }
            if (ArrayUtils.contains((Object[])__KERNEL_DEPENDENCIES_NEEDED, (Object)featureId)) {
                dependenciesOfFeature.add(0, "KERNEL");
            }
            if (!dependenciesOfFeature.isEmpty()) {
                sb.append("\n    --> brought by ").append(dependenciesOfFeature);
            }
            sb.append("\n\n");
        }
    }

    private Optional<IncludedFeature> _find(String featureId) {
        return this._includedFeatures.stream().filter(f -> featureId.equals(f.featureId())).findFirst();
    }

    public static final class IncludedFeature {
        private String _featureId;
        private String _cause;

        private IncludedFeature(String featureId, String cause) {
            this._featureId = featureId;
            this._cause = cause;
        }

        public static IncludedFeature of(String featureId, String cause) {
            return new IncludedFeature(featureId, cause);
        }

        public String featureId() {
            return this._featureId;
        }

        public String cause() {
            return this._cause;
        }
    }
}

