/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.datasource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ametys.core.datasource.AbstractDataSourceManager;
import org.ametys.core.datasource.DataSourceConsumerExtensionPoint;
import org.ametys.core.datasource.LDAPDataSourceManager;
import org.ametys.core.datasource.SQLDataSourceManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.checker.ItemCheckerTestFailureException;
import org.ametys.runtime.plugins.admin.notificator.AbstractConfigurableAdministratorNotificator;
import org.ametys.runtime.plugins.admin.notificator.Notification;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class InvalidDataSourceNotificator
extends AbstractConfigurableAdministratorNotificator
implements Serviceable {
    private SQLDataSourceManager _sqlDataSourceManager;
    private LDAPDataSourceManager _ldapDataSourceManager;
    private DataSourceConsumerExtensionPoint _dataSourceConsumerEP;

    public void service(ServiceManager smanager) throws ServiceException {
        this._sqlDataSourceManager = (SQLDataSourceManager)smanager.lookup(SQLDataSourceManager.ROLE);
        this._ldapDataSourceManager = (LDAPDataSourceManager)smanager.lookup(LDAPDataSourceManager.ROLE);
        this._dataSourceConsumerEP = (DataSourceConsumerExtensionPoint)smanager.lookup(DataSourceConsumerExtensionPoint.ROLE);
    }

    @Override
    public List<Notification> getNotifications() {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        Map<String, AbstractDataSourceManager.DataSourceDefinition> sqlDataSources = this._sqlDataSourceManager.getDataSourceDefinitions(true, true, false);
        for (String id : sqlDataSources.keySet()) {
            AbstractDataSourceManager.DataSourceDefinition datasource = sqlDataSources.get(id);
            if (this._dataSourceConsumerEP.isInUse(id)) continue;
            this._checkSqlDatasource(datasource, notifications);
        }
        Map<String, AbstractDataSourceManager.DataSourceDefinition> ldapDataSources = this._ldapDataSourceManager.getDataSourceDefinitions(true, true, false);
        for (String id : ldapDataSources.keySet()) {
            AbstractDataSourceManager.DataSourceDefinition datasource = ldapDataSources.get(id);
            if (this._dataSourceConsumerEP.isInUse(id)) continue;
            this._checkLdapDatasource(datasource, notifications);
        }
        return notifications;
    }

    private Notification _getNotification(String datasourceName) {
        I18nizableText message = new I18nizableText(this._message.getCatalogue(), this._message.getKey(), Collections.singletonList(datasourceName));
        return new Notification(this._type, new I18nizableText(this._title.getCatalogue(), this._title.getKey()), message, this._iconGlyph, this._action);
    }

    private void _checkSqlDatasource(AbstractDataSourceManager.DataSourceDefinition datasource, List<Notification> notifications) {
        try {
            this._sqlDataSourceManager.checkParameters(datasource.getParameters());
        }
        catch (ItemCheckerTestFailureException e) {
            notifications.add(this._getNotification(datasource.getName().getLabel()));
        }
    }

    private void _checkLdapDatasource(AbstractDataSourceManager.DataSourceDefinition datasource, List<Notification> notifications) {
        try {
            this._ldapDataSourceManager.checkParameters(datasource.getParameters());
        }
        catch (ItemCheckerTestFailureException e) {
            notifications.add(this._getNotification(datasource.getName().getLabel()));
        }
    }
}

