/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus.monitoring;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.mail.MessagingException;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.MonitoringConstants;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.MonitoringExtensionPoint;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.SampleManager;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.alerts.AlertSampleManager;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.FileUtils;
import org.rrd4j.core.RrdDb;

public class RRDsFeederTimerTask
extends TimerTask
implements Component,
LogEnabled,
Serviceable,
Initializable,
Disposable,
MonitoringConstants {
    private static final String __CONFIG_ALERTS_ENABLED = "runtime.system.alerts.enable";
    private static final String __CONFIG_FROM_MAIL = "smtp.mail.from";
    private static final String __CONFIG_ADMIN_MAIL = "smtp.mail.sysadminto";
    private Logger _logger;
    private MonitoringExtensionPoint _monitoringExtensionPoint;
    private Timer _timer;
    private String _rrdStoragePath;
    private I18nUtils _i18nUtils;
    private Map<String, Map<String, Boolean>> _currentAlerts;

    public void enableLogging(Logger logger) {
        this._logger = logger;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._monitoringExtensionPoint = (MonitoringExtensionPoint)manager.lookup(MonitoringExtensionPoint.ROLE);
        this._i18nUtils = (I18nUtils)((Object)manager.lookup(I18nUtils.ROLE));
    }

    public void initialize() throws Exception {
        this._rrdStoragePath = FileUtils.getFile((File)RuntimeConfig.getInstance().getAmetysHome(), (String[])new String[]{"monitoring"}).getPath();
        this._logger.debug("Starting timer");
        this._timer = new Timer("RRDFeeder", true);
        this._timer.scheduleAtFixedRate((TimerTask)this, 30000L, 60000L);
        this._currentAlerts = new LinkedHashMap<String, Map<String, Boolean>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Time to collect data");
        }
        for (String extensionId : this._monitoringExtensionPoint.getExtensionsIds()) {
            SampleManager sampleManager = (SampleManager)this._monitoringExtensionPoint.getExtension(extensionId);
            if (sampleManager == null) continue;
            String sampleName = sampleManager.getId();
            File rrdFile = new File(this._rrdStoragePath, sampleName + ".rrd");
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Collecting sample for: " + sampleName);
            }
            RrdDb rrdDb = null;
            try {
                rrdDb = new RrdDb(rrdFile.getPath());
                Map<String, Object> collectedValues = sampleManager.collect(rrdDb.createSample());
                if (!(sampleManager instanceof AlertSampleManager)) continue;
                this._checkIfAlert((AlertSampleManager)sampleManager, collectedValues);
            }
            catch (Exception e) {
                this._logger.error("Unable to collect sample for: " + sampleName, (Throwable)e);
            }
            finally {
                if (rrdDb == null) continue;
                try {
                    rrdDb.close();
                }
                catch (IOException e) {
                    this._logger.warn("Unable to close RRD file: " + rrdFile, (Throwable)e);
                }
            }
        }
    }

    private void _checkIfAlert(AlertSampleManager sampleManager, Map<String, Object> collectedValues) {
        if (Config.getInstance() == null) {
            return;
        }
        if (Config.getInstance().getValue(__CONFIG_ALERTS_ENABLED, true, false).booleanValue()) {
            if (this._currentAlerts.get(sampleManager.getId()) == null) {
                this._currentAlerts.put(sampleManager.getId(), new HashMap());
            }
            Map<String, AlertSampleManager.Threshold> thresholds = sampleManager.getThresholdValues();
            for (String datasourceName : thresholds.keySet()) {
                AlertSampleManager.Threshold threshold;
                if (this._currentAlerts.get(sampleManager.getId()).get(datasourceName) == null) {
                    this._currentAlerts.get(sampleManager.getId()).put(datasourceName, false);
                }
                if ((threshold = thresholds.get(datasourceName)).isExceeded(collectedValues.get(datasourceName)) && !this._currentAlerts.get(sampleManager.getId()).get(datasourceName).booleanValue()) {
                    this._sendAlertMail(threshold.getMailSubject(), threshold.getMailBody(), collectedValues.get(datasourceName).toString(), threshold.getValue().toString());
                    this._currentAlerts.get(sampleManager.getId()).put(datasourceName, true);
                    continue;
                }
                if (threshold.isExceeded(collectedValues.get(datasourceName)) || !this._currentAlerts.get(sampleManager.getId()).get(datasourceName).booleanValue()) continue;
                this._currentAlerts.get(sampleManager.getId()).put(datasourceName, false);
            }
        }
    }

    private void _sendAlertMail(I18nizableText subject, I18nizableText body, String currentValue, String thresholdValue) {
        block2: {
            Config config = Config.getInstance();
            String toMail = (String)config.getValue(__CONFIG_ADMIN_MAIL);
            String fromMail = (String)config.getValue(__CONFIG_FROM_MAIL);
            try {
                String subjectStr = this._i18nUtils.translate(subject, "fr");
                ArrayList<String> bodyParams = new ArrayList<String>();
                bodyParams.add(currentValue);
                bodyParams.add(thresholdValue);
                I18nizableText bodyWithParams = body.isI18n() ? new I18nizableText(body.getCatalogue(), body.getKey(), bodyParams) : body;
                String bodyStr = this._i18nUtils.translate(bodyWithParams, "fr");
                SendMailHelper.sendMail(subjectStr, null, bodyStr, toMail, fromMail);
            }
            catch (MessagingException e) {
                if (!this._logger.isWarnEnabled()) break block2;
                this._logger.warn("Could not send an alert e-mail to " + toMail, (Throwable)e);
            }
        }
    }

    public void dispose() {
        this._logger = null;
        this._monitoringExtensionPoint = null;
        this._rrdStoragePath = null;
        this.cancel();
        this._timer.cancel();
    }
}

