/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus.monitoring.sample;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.sample.AbstractSampleManager;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.sample.DiskIOMonitor;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.sample.SigarDiskIOMonitor;
import org.apache.avalon.framework.activity.Initializable;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;

public class DiskIOSampleManager
extends AbstractSampleManager
implements Initializable {
    private DiskIOMonitor _ioMonitor;
    private Map<String, Double> _previousMetrics;

    public void initialize() throws Exception {
        this._logger.debug("Initializing DiskIOSampleManager");
        try {
            this._ioMonitor = new SigarDiskIOMonitor();
            this._logger.info("Loaded Sigar native library");
        }
        catch (Exception e) {
            this._logger.warn("Cannot load Sigar native library");
        }
    }

    @Override
    protected String _getGraphTitle() {
        return "Filesystem disk I/O";
    }

    @Override
    protected void _configureDatasources(RrdDef rrdDef) {
        this._registerDatasources(rrdDef, "reads", DsType.GAUGE, 0.0, Double.NaN);
        this._registerDatasources(rrdDef, "writes", DsType.GAUGE, 0.0, Double.NaN);
    }

    @Override
    protected Map<String, Object> _internalCollect(Sample sample) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        double reads = Double.NaN;
        double writes = Double.NaN;
        if (this._ioMonitor != null) {
            this._ioMonitor.refresh();
            Map<String, Double> metrics = this._ioMonitor.toMap();
            if (this._previousMetrics != null) {
                reads = Math.max(0.0, metrics.get("reads") - this._previousMetrics.get("reads"));
                writes = Math.max(0.0, metrics.get("writes") - this._previousMetrics.get("writes"));
                sample.setValue("reads", reads);
                result.put("reads", reads);
                sample.setValue("writes", writes);
                result.put("writes", writes);
            }
            this._previousMetrics = metrics;
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("reads=" + reads + ", writes=" + writes);
        }
        return result;
    }
}

