/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.workspace;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.ametys.runtime.workspace.Workspace;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.XMLReader;

public final class WorkspaceManager {
    private static WorkspaceManager __manager;
    private static final String __WORKSPACE_FILENAME = "workspace.xml";
    private Map<String, Workspace> _workspaces = new HashMap<String, Workspace>();
    private Map<String, InactivityCause> _inactiveWorkspaces = new HashMap<String, InactivityCause>();
    private Logger _logger = LoggerFactory.getLogger(WorkspaceManager.class);

    private WorkspaceManager() {
    }

    public static WorkspaceManager getInstance() {
        if (__manager == null) {
            __manager = new WorkspaceManager();
        }
        return __manager;
    }

    public Set<String> getWorkspaceNames() {
        return Collections.unmodifiableSet(this._workspaces.keySet());
    }

    public Map<String, Workspace> getWorkspaces() {
        return Collections.unmodifiableMap(this._workspaces);
    }

    public Map<String, InactivityCause> getInactiveWorkspaces() {
        return Collections.unmodifiableMap(this._inactiveWorkspaces);
    }

    public Set<String> getEmbeddedWorskpacesIds() {
        return this._workspaces.keySet();
    }

    public String getBaseURI(String workspaceName) {
        return this._workspaces.get(workspaceName).getEmbededLocation();
    }

    public File getLocation(String workspaceName) {
        return this._workspaces.get(workspaceName).getExternalLocation();
    }

    public void init(Collection<String> excludedWorkspace, String contextPath) throws IOException {
        this._workspaces.clear();
        Enumeration<URL> workspaceResources = this.getClass().getClassLoader().getResources("META-INF/ametys-workspaces");
        while (workspaceResources.hasMoreElements()) {
            URL workspaceResource = workspaceResources.nextElement();
            this._initResourceWorkspace(excludedWorkspace, workspaceResource);
        }
        File workspacesDir = new File(contextPath, "workspaces");
        if (workspacesDir.exists() && workspacesDir.isDirectory()) {
            for (File workspace : new File(contextPath, "workspaces").listFiles()) {
                this._initFileWorkspaces(workspace, workspace.getName(), excludedWorkspace);
            }
        }
        Map<String, File> externalWorkspaces = RuntimeConfig.getInstance().getExternalWorkspaces();
        for (String externalWorkspace : externalWorkspaces.keySet()) {
            File workspaceDir = externalWorkspaces.get(externalWorkspace);
            if (workspaceDir.exists() && workspaceDir.isDirectory()) {
                this._initFileWorkspaces(workspaceDir, externalWorkspace, excludedWorkspace);
                continue;
            }
            throw new RuntimeException("The configured external workspace is not an existing directory: " + workspaceDir.getAbsolutePath());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _initResourceWorkspace(Collection<String> excludedWorkspace, URL workspaceResource) throws IOException {
        try (InputStream is = workspaceResource.openStream();
             BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
            String workspaceString;
            while ((workspaceString = br.readLine()) != null) {
                int i = workspaceString.indexOf(58);
                if (i == -1) continue;
                String workspaceName = workspaceString.substring(0, i);
                String workspaceBaseURI = workspaceString.substring(i + 1);
                if (!excludedWorkspace.contains(workspaceName)) {
                    if (this._workspaces.containsKey(workspaceName)) {
                        String errorMessage = "The workspace named " + workspaceName + " already exists";
                        this._logger.error(errorMessage);
                        throw new IllegalArgumentException(errorMessage);
                    }
                    URL workspaceConfigurationURL = this.getClass().getResource(workspaceBaseURI + "/" + __WORKSPACE_FILENAME);
                    if (workspaceConfigurationURL == null || this.getClass().getResource(workspaceBaseURI + "/" + __WORKSPACE_FILENAME) == null) {
                        if (this._logger.isWarnEnabled()) {
                            this._logger.warn("A workspace '" + workspaceName + "' is declared in a library, but files '" + __WORKSPACE_FILENAME + "' and/or 'sitemap.xmap' are missing at '" + workspaceBaseURI + "'. Workspace will be ignored.");
                        }
                        this._inactiveWorkspaces.put(workspaceName, InactivityCause.MISDECLARED);
                        return;
                    }
                    Configuration workspaceConfiguration = null;
                    try (InputStream is2 = workspaceConfigurationURL.openStream();){
                        workspaceConfiguration = this._getConfigurationFromStream(workspaceName, is2, workspaceBaseURI);
                    }
                    if (workspaceConfiguration != null) {
                        Workspace workspace = new Workspace(workspaceName, workspaceBaseURI);
                        workspace.configure(workspaceConfiguration);
                        this._workspaces.put(workspaceName, workspace);
                        if (!this._logger.isInfoEnabled()) continue;
                        this._logger.info("Workspace '" + workspaceName + "' registered at '" + workspaceBaseURI + "'");
                        continue;
                    }
                    this._inactiveWorkspaces.put(workspaceName, InactivityCause.MISCONFIGURED);
                    continue;
                }
                this._inactiveWorkspaces.put(workspaceName, InactivityCause.EXCLUDED);
            }
            return;
        }
    }

    private void _initFileWorkspaces(File workspaceFile, String workspaceName, Collection<String> excludedWorkspace) throws IOException {
        File workspaceConfigurationFile = new File(workspaceFile, __WORKSPACE_FILENAME);
        if (excludedWorkspace.contains(workspaceName)) {
            this._inactiveWorkspaces.put(workspaceName, InactivityCause.EXCLUDED);
        } else if (workspaceFile.exists() && workspaceFile.isDirectory() && workspaceConfigurationFile.exists() && new File(workspaceFile, "sitemap.xmap").exists()) {
            if (this._workspaces.containsKey(workspaceName)) {
                String errorMessage = "The workspace named " + workspaceFile.getName() + " already exists";
                this._logger.error(errorMessage);
                throw new IllegalArgumentException(errorMessage);
            }
            Configuration workspaceConfiguration = null;
            try (FileInputStream is = new FileInputStream(workspaceConfigurationFile);){
                workspaceConfiguration = this._getConfigurationFromStream(workspaceName, is, workspaceConfigurationFile.getAbsolutePath());
            }
            if (workspaceConfiguration != null) {
                Workspace workspace = new Workspace(workspaceName, workspaceFile);
                workspace.configure(workspaceConfiguration);
                this._workspaces.put(workspaceName, workspace);
                if (this._logger.isInfoEnabled()) {
                    this._logger.info("Workspace '" + workspaceName + "' registered at '" + workspaceConfigurationFile.getAbsolutePath() + "'");
                }
            } else {
                this._inactiveWorkspaces.put(workspaceName, InactivityCause.MISCONFIGURED);
            }
        } else {
            if (this._logger.isWarnEnabled()) {
                this._logger.warn("Workspace '" + workspaceName + "' registered at '" + workspaceFile.getAbsolutePath() + "' has no '" + __WORKSPACE_FILENAME + "' file or no 'sitemap.xmap' file.");
            }
            this._inactiveWorkspaces.put(workspaceName, InactivityCause.MISDECLARED);
        }
    }

    private Configuration _getConfigurationFromStream(String workspaceName, InputStream is, String path) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL schemaURL = this.getClass().getResource("workspace-4.0.xsd");
            Schema schema = schemaFactory.newSchema(schemaURL);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setSchema(schema);
            XMLReader reader = factory.newSAXParser().getXMLReader();
            DefaultConfigurationBuilder confBuilder = new DefaultConfigurationBuilder(reader);
            return confBuilder.build(is, path);
        }
        catch (Exception e) {
            this._logger.error("Unable to access to workspace '" + workspaceName + "' at " + path, (Throwable)e);
            return null;
        }
    }

    public static enum InactivityCause {
        EXCLUDED,
        MISDECLARED,
        MISCONFIGURED;

    }
}

