/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repositoryapp;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Context;
import org.apache.jackrabbit.api.JackrabbitRepository;

public class RepositoryProvider
extends AbstractLogEnabled
implements Contextualizable,
Component {
    public static final String ROLE = RepositoryProvider.class.getName();
    public static final String SESSION_JCR_SESSIONS_KEY = "org.ametys.repository.Sessions";
    public static final String CONTEXT_REPOSITORY_KEY = "org.ametys.repository.Repository";
    public static final String CONTEXT_IS_JNDI_KEY = "org.ametys.repository.JNDI";
    private static final String _CONTEXT_CREDENTIALS_KEY = "org.ametys.repository.Credentials";
    private org.apache.avalon.framework.context.Context _avalonContext;
    private Context _context;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._avalonContext = context;
        this._context = (Context)context.get((Object)"environment-context");
    }

    public Repository getRepository() {
        return (Repository)this._context.getAttribute(CONTEXT_REPOSITORY_KEY);
    }

    public Credentials getCredentials() {
        return (Credentials)this._context.getAttribute(_CONTEXT_CREDENTIALS_KEY);
    }

    public boolean isJndi() {
        return (Boolean)this._context.getAttribute(CONTEXT_IS_JNDI_KEY);
    }

    public void registerRepository(Repository repository, Credentials credentials, boolean jndi) {
        this._context.setAttribute(CONTEXT_REPOSITORY_KEY, (Object)repository);
        this._context.setAttribute(_CONTEXT_CREDENTIALS_KEY, (Object)credentials);
        this._context.setAttribute(CONTEXT_IS_JNDI_KEY, (Object)jndi);
    }

    public Map<String, Session> getSessions() {
        org.apache.cocoon.environment.Session httpSession = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._avalonContext).getSession();
        HashMap sessions = (HashMap)httpSession.getAttribute(SESSION_JCR_SESSIONS_KEY);
        if (sessions == null) {
            sessions = new HashMap();
            httpSession.setAttribute(SESSION_JCR_SESSIONS_KEY, sessions);
        }
        return sessions;
    }

    public Session getSession(String workspaceName) throws RepositoryException {
        Map<String, Session> sessions = this.getSessions();
        Session session = sessions.get(workspaceName);
        if (session == null || !session.isLive()) {
            Repository repository = this.getRepository();
            Credentials credentials = this.getCredentials();
            session = repository.login(credentials, workspaceName);
            sessions.put(workspaceName, session);
        }
        return session;
    }

    public void disconnect() {
        Map<String, Session> sessions = this.getSessions();
        for (Session session : sessions.values()) {
            session.logout();
        }
        org.apache.cocoon.environment.Session httpSession = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._avalonContext).getSession();
        httpSession.removeAttribute(SESSION_JCR_SESSIONS_KEY);
        Repository repository = this.getRepository();
        if (!this.isJndi() && repository instanceof JackrabbitRepository) {
            ((JackrabbitRepository)repository).shutdown();
        }
        this._context.removeAttribute(CONTEXT_REPOSITORY_KEY);
        this._context.removeAttribute(_CONTEXT_CREDENTIALS_KEY);
        this._context.removeAttribute(CONTEXT_IS_JNDI_KEY);
    }
}

