/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.repositoryapp.jcr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.plugins.repositoryapp.RepositoryProvider;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.workspaces.repository.jcr.RepositoryDao;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.servlet.multipart.PartOnDisk;
import org.apache.commons.lang3.StringUtils;

public class SetPropertyAction
extends ServiceableAction {
    protected static final DateFormat _DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected RepositoryProvider _repositoryProvider;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._repositoryProvider = (RepositoryProvider)((Object)serviceManager.lookup(RepositoryProvider.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver sourceResolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String workspaceName = request.getParameter("workspace");
        Session session = this._repositoryProvider.getSession(workspaceName);
        String nodePath = request.getParameter("path");
        String propertyName = request.getParameter("name");
        Object[] values = request.getParameterValues("value");
        String type = request.getParameter("type");
        boolean multiple = Boolean.valueOf(request.getParameter("multiple"));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Trying to add property: '" + propertyName + "' to the node at path: '" + nodePath + "'");
        }
        String relPath = RepositoryDao.removeLeadingSlash(nodePath);
        Node node = null;
        node = StringUtils.isEmpty((CharSequence)relPath) ? session.getRootNode() : session.getRootNode().getNode(relPath);
        int jcrType = PropertyType.valueFromName((String)StringUtils.capitalize((String)type));
        try {
            if (type.equalsIgnoreCase("Date")) {
                this._setDate(node, propertyName, (String[])values);
            } else if (type.equalsIgnoreCase("Binary")) {
                this._setBinary(session, request, node, propertyName);
            } else if (type.equalsIgnoreCase("Reference")) {
                this._setReference(session, node, propertyName, (String[])values, multiple);
            } else {
                this._setValue(node, propertyName, (String[])values, multiple, jcrType);
            }
            result.put("success", true);
        }
        catch (RepositoryException e) {
            this.getLogger().error("Unable to set value " + Arrays.toString(values) + " for property '" + propertyName + "'", (Throwable)e);
            result.put("success", false);
            result.put("message", e.toString());
        }
        catch (ParseException e) {
            this.getLogger().error("Unable to set value " + Arrays.toString(values) + " for property '" + propertyName + "'", (Throwable)e);
            result.put("success", false);
            I18nizableText message = new I18nizableText("plugin.repositoryapp", "PLUGINS_REPOSITORYAPP_CREATE_PROP_ERROR_DATE", Collections.singletonMap("error", new I18nizableText(e.getMessage())));
            result.put("message", message);
        }
        catch (Exception e) {
            this.getLogger().error("Unable to set value " + Arrays.toString(values) + " for property '" + propertyName + "'", (Throwable)e);
            result.put("success", false);
            result.put("message", e.toString());
        }
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    private void _setDate(Node node, String propertyName, String[] value) throws RepositoryException, ParseException {
        Date date = _DATE_FORMAT.parse(value[0]);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        node.setProperty(propertyName, cal);
    }

    private void _setBinary(Session session, Request request, Node node, String propertyName) throws RepositoryException, IOException {
        PartOnDisk uploadedFilePart = (PartOnDisk)request.get(propertyName);
        if (uploadedFilePart == null) {
            uploadedFilePart = (PartOnDisk)request.get("fieldValue");
        }
        File uploadedFile = uploadedFilePart != null ? uploadedFilePart.getFile() : null;
        FileInputStream is = new FileInputStream(uploadedFile);
        Binary binary = session.getValueFactory().createBinary((InputStream)is);
        node.setProperty(propertyName, binary);
    }

    private void _setReference(Session session, Node node, String propertyName, String[] value, boolean multiple) throws RepositoryException {
        boolean isMultiple;
        ArrayList<Value> values = new ArrayList<Value>();
        ValueFactory vf = session.getValueFactory();
        for (String v : value) {
            values.add(vf.createValue(session.getNodeByIdentifier(v)));
        }
        boolean bl = isMultiple = multiple || node.hasProperty(propertyName) && node.getProperty(propertyName).getDefinition().isMultiple();
        if (isMultiple) {
            node.setProperty(propertyName, values.toArray(new Value[values.size()]));
        } else {
            node.setProperty(propertyName, (Value)values.get(0));
        }
    }

    private void _setValue(Node node, String propertyName, String[] value, boolean multiple, int jcrType) throws RepositoryException {
        boolean isMultiple;
        boolean bl = isMultiple = multiple || node.hasProperty(propertyName) && node.getProperty(propertyName).getDefinition().isMultiple();
        if (isMultiple) {
            node.setProperty(propertyName, value, jcrType);
        } else {
            node.setProperty(propertyName, value[0], jcrType);
        }
    }
}

