/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.SimpleCredentials;
import javax.naming.InitialContext;
import org.ametys.core.util.SystemStatus;
import org.ametys.plugins.repositoryapp.RepositoryProvider;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.jackrabbit.core.TransientRepository;
import org.apache.jackrabbit.core.config.RepositoryConfig;

public class ConnectAction
extends ServiceableAction
implements ThreadSafe {
    protected RepositoryProvider _repositoryProvider;
    protected SystemStatus _systemStatus;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._repositoryProvider = (RepositoryProvider)((Object)serviceManager.lookup(RepositoryProvider.ROLE));
        this._systemStatus = (SystemStatus)serviceManager.lookup(SystemStatus.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver sourceResolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        if (this._repositoryProvider.getRepository() != null) {
            return null;
        }
        if (this._systemStatus.getStatus().contains("REPOSITORY_UNAVAILABLE")) {
            return null;
        }
        String mode = request.getParameter("mode");
        if (mode == null) {
            result.put("result", "form");
            return result;
        }
        try {
            Repository repository = null;
            boolean jndi = "jndi".equals(mode);
            if (!jndi) {
                String path = request.getParameter("repository-path");
                String configFile = request.getParameter("repository-xml");
                RepositoryConfig config = RepositoryConfig.create((String)configFile, (String)path);
                repository = new TransientRepository(config);
            } else {
                String jndiContext = request.getParameter("jndi-context");
                InitialContext ctx = new InitialContext();
                repository = (Repository)ctx.lookup(jndiContext);
            }
            String user = request.getParameter("user");
            String pwd = request.getParameter("password");
            SimpleCredentials credentials = new SimpleCredentials(user, pwd.toCharArray());
            this._repositoryProvider.registerRepository(repository, (Credentials)credentials, jndi);
            this._repositoryProvider.getSession("default");
            return null;
        }
        catch (Exception e) {
            this.getLogger().error("Error connecting to the repository.", (Throwable)e);
            result.put("result", "error");
            result.put("error", "connection");
            return result;
        }
    }
}

