/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.jcr;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import org.ametys.plugins.repositoryapp.RepositoryProvider;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class NodeTypeHierarchyComponent
extends AbstractLogEnabled
implements Component,
Contextualizable,
Serviceable {
    public static final String ROLE = NodeTypeHierarchyComponent.class.getName();
    protected Map<String, Map<String, Set<String>>> _subTypes;
    protected RepositoryProvider _repositoryProvider;
    protected Context _context;
    protected ServiceManager _manager;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._repositoryProvider = (RepositoryProvider)((Object)manager.lookup(RepositoryProvider.ROLE));
    }

    public Set<String> getDirectSubTypes(NodeType nodeType, String workspaceName) throws RepositoryException {
        if (this._subTypes == null || !this._subTypes.containsKey(workspaceName)) {
            this._buildTypeHierarchy(workspaceName);
        }
        if (this._subTypes.get(workspaceName).containsKey(nodeType.getName())) {
            return Collections.unmodifiableSet(this._subTypes.get(workspaceName).get(nodeType.getName()));
        }
        return Collections.emptySet();
    }

    public Set<String> getRecursiveSubTypes(String nodeType, String workspaceName) throws RepositoryException {
        if (this._subTypes == null || !this._subTypes.containsKey(workspaceName)) {
            this._buildTypeHierarchy(workspaceName);
        }
        HashSet<String> allTypes = new HashSet<String>();
        if (this._subTypes.get(workspaceName).containsKey(nodeType)) {
            for (String subType : this._subTypes.get(workspaceName).get(nodeType)) {
                allTypes.add(subType);
                allTypes.addAll(this.getRecursiveSubTypes(subType, workspaceName));
            }
        }
        return allTypes;
    }

    public Set<String> getAvailableChildrenTypes(NodeDefinition nodeDef, String workspaceName) throws RepositoryException {
        if (this._subTypes == null || !this._subTypes.containsKey(workspaceName)) {
            this._buildTypeHierarchy(workspaceName);
        }
        HashSet<String> types = new HashSet<String>();
        NodeType[] requiredTypes = nodeDef.getRequiredPrimaryTypes();
        if (requiredTypes.length > 0) {
            types.add(requiredTypes[0].getName());
            types.addAll(this.getRecursiveSubTypes(requiredTypes[0].getName(), workspaceName));
        }
        for (int i = 1; i < requiredTypes.length; ++i) {
            types.add(requiredTypes[0].getName());
            types.retainAll(this.getRecursiveSubTypes(requiredTypes[0].getName(), workspaceName));
        }
        return types;
    }

    protected void _buildTypeHierarchy(String workspaceName) throws RepositoryException {
        if (this._subTypes == null) {
            this._subTypes = new HashMap<String, Map<String, Set<String>>>();
        }
        HashMap workspaceTypes = new HashMap();
        this._subTypes.put(workspaceName, workspaceTypes);
        Request request = ContextHelper.getRequest((Context)this._context);
        try {
            Workspace workspace = this._getWorkspace(request, workspaceName);
            NodeTypeManager ntManager = workspace.getNodeTypeManager();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Computing node type hierarchy for workspace " + workspaceName);
            }
            NodeTypeIterator nodeTypes = ntManager.getPrimaryNodeTypes();
            while (nodeTypes.hasNext()) {
                NodeType nodeType = nodeTypes.nextNodeType();
                for (NodeType supertype : nodeType.getSupertypes()) {
                    if (supertype.isMixin()) continue;
                    Set<String> subtypes = null;
                    if (workspaceTypes.containsKey(supertype.getName())) {
                        subtypes = (Set)workspaceTypes.get(supertype.getName());
                    } else {
                        subtypes = new HashSet();
                        workspaceTypes.put(supertype.getName(), subtypes);
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(nodeType.getName() + " is a sub type of " + supertype.getName());
                    }
                    subtypes.add(nodeType.getName());
                }
            }
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    protected Workspace _getWorkspace(Request request, String workspaceName) throws RepositoryException, ServiceException {
        Session session = this._repositoryProvider.getSession(workspaceName);
        return session.getWorkspace();
    }
}

