/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.jcr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.NodeDefinition;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.repositoryapp.RepositoryProvider;
import org.ametys.runtime.config.Config;
import org.ametys.workspaces.repository.jcr.NodeGroupHelper;
import org.ametys.workspaces.repository.jcr.NodeStateTracker;
import org.ametys.workspaces.repository.jcr.NodeTypeHierarchyComponent;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class RepositoryDao
extends AbstractLogEnabled
implements Component,
Serviceable {
    protected RepositoryProvider _repositoryProvider;
    protected NodeStateTracker _nodeStateTracker;
    protected NodeTypeHierarchyComponent _nodeTypeHierarchy;
    private ServiceManager _serviceManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._serviceManager = serviceManager;
        this._repositoryProvider = (RepositoryProvider)((Object)serviceManager.lookup(RepositoryProvider.ROLE));
        this._nodeStateTracker = (NodeStateTracker)((Object)serviceManager.lookup(NodeStateTracker.ROLE));
        this._nodeTypeHierarchy = (NodeTypeHierarchyComponent)((Object)serviceManager.lookup(NodeTypeHierarchyComponent.ROLE));
    }

    @Callable
    public Map<String, Object> getRepositoryInfo() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("standalone", this._serviceManager.hasService(Repository.class.getName()));
        Config configInstance = Config.getInstance();
        if (configInstance != null) {
            String defaultOrder = (String)configInstance.getValue("repository.default.sort");
            info.put("defaultOrder", defaultOrder);
        }
        return info;
    }

    @Callable
    public List<String> getWorkspaces() throws RepositoryException {
        Session session = this._repositoryProvider.getSession("default");
        Workspace workspace = session.getWorkspace();
        return Arrays.asList(workspace.getAccessibleWorkspaceNames());
    }

    @Callable
    public Map<String, Object> getNodesByPath(Collection<String> paths, String workspaceName) throws RepositoryException {
        Session session = this._repositoryProvider.getSession(workspaceName);
        Node rootNode = session.getRootNode();
        ArrayList<HashMap<String, Object>> nodes = new ArrayList<HashMap<String, Object>>();
        ArrayList<String> notFound = new ArrayList<String>();
        for (String path : paths) {
            try {
                Node node = null;
                String relPath = RepositoryDao.removeLeadingSlash(path);
                node = StringUtils.isEmpty((CharSequence)relPath) ? rootNode : rootNode.getNode(relPath);
                HashMap<String, Object> nodeInfo = new HashMap<String, Object>();
                this.fillNodeInfo(node, nodeInfo);
                nodes.add(nodeInfo);
            }
            catch (PathNotFoundException e) {
                notFound.add(path);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("nodes", nodes);
        result.put("notFound", notFound);
        return result;
    }

    @Callable
    public Map<String, Object> getNodeByPath(String path, String workspaceName) throws RepositoryException {
        Session session = this._repositoryProvider.getSession(workspaceName);
        String relPath = RepositoryDao.removeLeadingSlash(path);
        Node node = session.getRootNode().getNode(relPath);
        HashMap<String, Object> nodeInfo = new HashMap<String, Object>();
        this.fillNodeInfo(node, nodeInfo);
        return nodeInfo;
    }

    @Callable
    public Map<String, Object> getNodeByIdentifier(String identifier, String workspaceName) throws RepositoryException {
        Session session = this._repositoryProvider.getSession(workspaceName);
        try {
            Node node = session.getNodeByIdentifier(identifier);
            HashMap<String, Object> nodeInfo = new HashMap<String, Object>();
            this.fillNodeInfo(node, nodeInfo);
            return nodeInfo;
        }
        catch (ItemNotFoundException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn(String.format("Item '%s' not found in workspace '%s'", identifier, workspaceName), (Throwable)e);
            }
            return null;
        }
    }

    @Callable
    public Set<String> getChildrenTypes(String nodePath, String workspaceName) throws RepositoryException {
        NodeDefinition[] childNodeDefinitions;
        Session session = this._repositoryProvider.getSession(workspaceName);
        String relPath = RepositoryDao.removeLeadingSlash(nodePath);
        Node node = null;
        node = StringUtils.isEmpty((CharSequence)relPath) ? session.getRootNode() : session.getRootNode().getNode(relPath);
        HashSet<String> availableChildrenTypes = new HashSet<String>();
        for (NodeDefinition nodeDef : childNodeDefinitions = node.getPrimaryNodeType().getChildNodeDefinitions()) {
            availableChildrenTypes.addAll(this._nodeTypeHierarchy.getAvailableChildrenTypes(nodeDef, workspaceName));
        }
        return availableChildrenTypes;
    }

    @Callable
    public Map<String, Object> addNode(String parentPath, String childName, String childType, String workspaceName) throws RepositoryException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Trying to add child: '" + childName + "' to the node at path: '" + parentPath + "'");
        }
        Session session = this._repositoryProvider.getSession(workspaceName);
        String relPath = RepositoryDao.removeLeadingSlash(parentPath);
        Node parentNode = null;
        parentNode = StringUtils.isEmpty((CharSequence)relPath) ? session.getRootNode() : session.getRootNode().getNode(relPath);
        Node childNode = parentNode.addNode(childName, childType);
        String fullPath = NodeGroupHelper.getPathWithGroups(childNode);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("path", childNode.getPath());
        result.put("pathWithGroups", fullPath);
        this._nodeStateTracker.nodeAdded(workspaceName, fullPath);
        return result;
    }

    @Callable
    public String removeNode(String path, String workspaceName) throws RepositoryException {
        Session session = this._repositoryProvider.getSession(workspaceName);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Trying to remove node at path: '" + path + "'");
        }
        String relPath = RepositoryDao.removeLeadingSlash(path);
        Node node = session.getRootNode().getNode(relPath);
        Node parentNode = node.getParent();
        String fullPath = NodeGroupHelper.getPathWithGroups(node);
        String fullParentPath = NodeGroupHelper.getPathWithGroups(parentNode);
        node.remove();
        this._nodeStateTracker.nodeRemoved(workspaceName, fullPath);
        this._nodeStateTracker.nodeAdded(workspaceName, fullParentPath);
        return fullParentPath;
    }

    @Callable
    public void removeProperty(String path, String workspaceName, String propertyName) throws RepositoryException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Removing property '" + propertyName + "' from the node at path '" + path + "'");
        }
        Session session = this._repositoryProvider.getSession(workspaceName);
        String relPath = RepositoryDao.removeLeadingSlash(path);
        Node node = null;
        node = StringUtils.isEmpty((CharSequence)relPath) ? session.getRootNode() : session.getRootNode().getNode(relPath);
        node.getProperty(propertyName).remove();
    }

    @Callable
    public void unlockNode(String path, String workspaceName) throws RepositoryException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Trying to unlock the node at path '" + path + "'");
        }
        Session session = this._repositoryProvider.getSession(workspaceName);
        LockManager lockManager = session.getWorkspace().getLockManager();
        try {
            Node node = session.getNode(path);
            if (node.hasProperty("ametys-internal:lockToken")) {
                String lockToken = node.getProperty("ametys-internal:lockToken").getString();
                lockManager.addLockToken(lockToken);
            } else if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Lock token property not found for node at path '" + path + "'");
            }
        }
        catch (RepositoryException e) {
            this.getLogger().warn("Unable to add locken token to unlock node at path '" + path + "'", (Throwable)e);
        }
        session.getWorkspace().getLockManager().unlock(path);
    }

    @Callable
    public void checkoutNode(String path, String workspaceName) throws RepositoryException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Trying to checkout the node at path '" + path + "'");
        }
        Session session = this._repositoryProvider.getSession(workspaceName);
        session.getWorkspace().getVersionManager().checkout(path);
    }

    @Callable
    public void saveSession(String workspaceName) throws RepositoryException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Persisting session for workspace '" + workspaceName + "'");
        }
        Session session = this._repositoryProvider.getSession(workspaceName);
        session.save();
        this._nodeStateTracker.clear(workspaceName);
    }

    @Callable
    public void rollbackSession(String workspaceName) throws RepositoryException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Rolling back session for workspace '" + workspaceName + "'");
        }
        Session session = this._repositoryProvider.getSession(workspaceName);
        session.refresh(false);
        this._nodeStateTracker.clear(workspaceName);
    }

    protected void fillNodeInfo(Node node, Map<String, Object> nodeInfo) throws RepositoryException {
        boolean hasOrderableChildNodes = true;
        nodeInfo.put("id", node.getIdentifier());
        nodeInfo.put("path", node.getPath());
        nodeInfo.put("pathWithGroups", NodeGroupHelper.getPathWithGroups(node));
        nodeInfo.put("name", node.getName());
        nodeInfo.put("index", node.getIndex());
        nodeInfo.put("hasOrderableChildNodes", hasOrderableChildNodes);
        nodeInfo.put("locked", node.isLocked());
        nodeInfo.put("checkedOut", node.isCheckedOut());
    }

    public static String addLeadingSlash(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path) && path.charAt(0) != '/') {
            return '/' + path;
        }
        return path;
    }

    public static String removeLeadingSlash(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path) && path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path;
    }
}

