/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.maintenance;

import java.util.HashMap;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.workspaces.repository.maintenance.MaintenanceTaskManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang.StringUtils;

public class MaintenanceTaskComponent
extends AbstractLogEnabled
implements Component,
Serviceable {
    private MaintenanceTaskManager _taskManager;

    public void service(ServiceManager smanager) throws ServiceException {
        this._taskManager = (MaintenanceTaskManager)((Object)smanager.lookup(MaintenanceTaskManager.ROLE));
    }

    @Callable
    public Map<String, Object> startTask(String taskName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            boolean launched = this._taskManager.launch(MaintenanceTaskManager.MaintenanceTaskType.valueOf(taskName));
            result.put("launched", launched);
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            result.put("launched", false);
        }
        result.put("running", this._taskManager.isTaskRunning());
        return result;
    }

    @Callable
    public Map<String, Object> isRunning(String taskName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String isRunning = Boolean.toString(this._taskManager.isTaskRunning());
        result.put("running", isRunning);
        return result;
    }

    @Callable
    public Map<String, Object> getInformation(String taskName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean taskRunning = this._taskManager.isTaskRunning();
        result.put("isRunning", taskRunning);
        if (taskRunning) {
            result.put("taskName", StringUtils.defaultString((String)this._taskManager.getRunningTaskType()));
        } else {
            result.put("lastTaskName", StringUtils.defaultString((String)this._taskManager.getLastRunningTaskType()));
        }
        result.put("progress", this._taskManager.getProgressInfo());
        result.put("respositoryState", this._taskManager.isRepositoryStarted());
        return result;
    }
}

