/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.maintenance;

import java.util.HashMap;
import java.util.Map;

public class TaskProgress {
    private final float _total;
    private float _progress;
    private State _state;
    private Exception _exception;

    public TaskProgress(float total) {
        this._total = total;
        this._progress = 0.0f;
        this._state = State.NEW;
    }

    public TaskProgress(float total, float start) {
        this(total);
        this._progress = start;
    }

    public void progress() {
        this.progress(1.0f);
    }

    public synchronized void progress(float quantity) {
        this._progress += quantity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressRelativePercentage(int percentage) {
        if (percentage < 0 || percentage > 100) {
            throw new IllegalArgumentException("percentage must be in the [0; 100] range.");
        }
        TaskProgress taskProgress = this;
        synchronized (taskProgress) {
            this._progress = percentage == 100 ? this._total : (this._progress += (this._total - this._progress) * (float)percentage / 100.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressTotalPercentage(int percentage) {
        if (percentage < 0 || percentage > 100) {
            throw new IllegalArgumentException("percentage must be in the [0; 100] range.");
        }
        TaskProgress taskProgress = this;
        synchronized (taskProgress) {
            this._progress = percentage == 100 ? this._total : this._total * (float)percentage / 100.0f;
        }
    }

    public synchronized float getProgressPercentage() {
        return Math.min(1.0f, this._progress / this._total);
    }

    public synchronized void setRunning() {
        this._state = State.RUNNING;
    }

    public synchronized void setFinished() {
        this._state = State.FINISHED;
    }

    public void setInErrorState() {
        this.setInErrorState(null);
    }

    public synchronized void setInErrorState(Exception e) {
        this._exception = e;
        this._state = State.ERROR_STATE;
    }

    public boolean isNotStarted() {
        return State.NEW.equals((Object)this._state);
    }

    public boolean isRunning() {
        return State.RUNNING.equals((Object)this._state);
    }

    public boolean isFinished() {
        return State.FINISHED.equals((Object)this._state);
    }

    public boolean isInErrorState() {
        return State.ERROR_STATE.equals((Object)this._state);
    }

    public Exception getException() {
        return this._exception;
    }

    public State getState() {
        return this._state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getProgressInfo() {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        TaskProgress taskProgress = this;
        synchronized (taskProgress) {
            infos.put("progress", Float.valueOf(this._progress));
            infos.put("total", Float.valueOf(this._total));
            infos.put("percentage", Float.valueOf(this.getProgressPercentage()));
            infos.put("state", this._state.name());
            if (this._exception != null) {
                infos.put("exception", this._exception.getLocalizedMessage());
            }
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder("Progress : ");
        TaskProgress taskProgress = this;
        synchronized (taskProgress) {
            sb.append(this.getProgressPercentage()).append(" ");
            sb.append("[").append(this._progress).append("/").append(this._total).append("]");
        }
        return sb.toString();
    }

    public static enum State {
        NEW,
        RUNNING,
        FINISHED,
        ERROR_STATE;

    }
}

