/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.maintenance.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.repositoryapp.RepositoryProvider;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class MaintenanceTaskClientSideElement
extends StaticClientSideElement {
    private RepositoryProvider _repositoryProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        if (smanager.hasService(RepositoryProvider.ROLE)) {
            this._repositoryProvider = (RepositoryProvider)((Object)smanager.lookup(RepositoryProvider.ROLE));
        }
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        ArrayList<ClientSideElement.Script> clonedScripts = new ArrayList<ClientSideElement.Script>();
        List scripts = super.getScripts(ignoreRights, contextParameters);
        for (ClientSideElement.Script script : scripts) {
            ClientSideElement.Script clonedScript = new ClientSideElement.Script(script);
            I18nizableText unavailableDescription = this.getUnavailableDescription();
            if (unavailableDescription != null) {
                clonedScript.getParameters().put("unavailable", true);
                clonedScript.getParameters().put("unavailable-description", unavailableDescription);
            }
            clonedScripts.add(clonedScript);
        }
        return clonedScripts;
    }

    protected I18nizableText getUnavailableDescription() {
        if (this.isJndi()) {
            return new I18nizableText("plugin.repositoryapp", "PLUGINS_REPOSITORYAPP_BUTTON_MAINTENANCE_TASK_JNDI_DESC");
        }
        return null;
    }

    protected boolean isJndi() {
        return this._repositoryProvider.isJndi();
    }
}

