/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.serializers;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.components.serializers.XMLSerializer;
import org.apache.cocoon.components.serializers.encoding.XHTMLEncoder;
import org.apache.cocoon.components.serializers.util.DocType;
import org.xml.sax.SAXException;

public class XHTMLSerializer
extends XMLSerializer {
    public static final String XHTML1_NAMESPACE = "http://www.w3.org/1999/xhtml";
    public static final DocType XHTML1_DOCTYPE_STRICT = new DocType("html", "-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
    public static final DocType XHTML1_DOCTYPE_TRANSITIONAL = new DocType("html", "-//W3C//DTD XHTML 1.0 Transitional//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
    public static final DocType XHTML1_DOCTYPE_FRAMESET = new DocType("html", "-//W3C//DTD XHTML 1.0 Frameset//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd");
    public static final DocType XHTML5_DOCTYPE = new DocType("html");
    private static final XHTMLEncoder XHTML_ENCODER = new XHTMLEncoder();
    protected boolean encodeCharacters = true;
    protected DocType doctype_default = null;
    private String omitXmlDeclaration = null;

    public XHTMLSerializer() {
        super(XHTML_ENCODER);
    }

    protected XHTMLSerializer(XHTMLEncoder encoder) {
        super(encoder);
    }

    @Override
    public String getMimeType() {
        if (this.charset == null) {
            return "text/html";
        }
        return "text/html; charset=" + this.charset.getName();
    }

    @Override
    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        this.omitXmlDeclaration = conf.getChild("omit-xml-declaration").getValue(null);
        String doctype = conf.getChild("doctype-default").getValue(null);
        this.doctype_default = "none".equalsIgnoreCase(doctype) ? null : ("strict".equalsIgnoreCase(doctype) ? XHTML1_DOCTYPE_STRICT : ("loose".equalsIgnoreCase(doctype) ? XHTML1_DOCTYPE_TRANSITIONAL : ("frameset".equalsIgnoreCase(doctype) ? XHTML1_DOCTYPE_FRAMESET : ("xhtml5".equalsIgnoreCase(doctype) ? XHTML5_DOCTYPE : XHTML1_DOCTYPE_TRANSITIONAL))));
    }

    @Override
    protected void head() throws SAXException {
        if (!"yes".equals(this.omitXmlDeclaration)) {
            super.head();
        }
    }

    @Override
    public void body(String uri, String local, String qual) throws SAXException {
        if (this.doctype == null) {
            this.doctype = this.doctype_default;
        }
        if (this.namespaces.getUri("").length() == 0) {
            this.namespaces.push("", XHTML1_NAMESPACE);
        }
        super.body(uri, local, qual);
    }

    @Override
    public void startElementImpl(String uri, String local, String qual, String[][] namespaces, String[][] attributes) throws SAXException {
        if (uri.length() == 0) {
            uri = XHTML1_NAMESPACE;
        }
        if (this.isCdataElement(local)) {
            this.encodeCharacters = false;
        }
        super.startElementImpl(uri, local, qual, namespaces, attributes);
    }

    @Override
    public void endElementImpl(String uri, String local, String qual) throws SAXException {
        if (uri.length() == 0) {
            uri = XHTML1_NAMESPACE;
        }
        if (XHTML1_NAMESPACE.equals(uri)) {
            if (local.equalsIgnoreCase("textarea") || local.equalsIgnoreCase("script") || local.equalsIgnoreCase("style")) {
                this.closeElement(false);
            } else if (local.equalsIgnoreCase("head")) {
                String loc = "meta";
                String qua = this.namespaces.qualify(XHTML1_NAMESPACE, loc, "meta");
                String[][] nsp = new String[0][0];
                String[][] att = new String[2][4];
                att[1][0] = "";
                att[0][0] = "";
                att[0][2] = "http-equiv";
                att[0][1] = "http-equiv";
                att[1][2] = "content";
                att[1][1] = "content";
                att[0][3] = "Content-Type";
                att[1][3] = this.getMimeType();
                this.closeElement(false);
                this.startElementImpl(XHTML1_NAMESPACE, loc, qua, nsp, att);
                this.endElementImpl(XHTML1_NAMESPACE, loc, qua);
            }
        }
        if (this.isCdataElement(local)) {
            this.encodeCharacters = true;
        }
        super.endElementImpl(uri, local, qual);
    }

    protected boolean isCdataElement(String localName) {
        String upperCase = localName.toUpperCase();
        return "SCRIPT".equals(upperCase) || "STYLE".equals(upperCase);
    }

    @Override
    protected void encode(char[] data, int start, int length) throws SAXException {
        if (this.encodeCharacters) {
            super.encode(data, start, length);
        } else {
            this.write(data, start, length);
        }
    }
}

