/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.serializers;

import java.io.CharArrayWriter;
import org.apache.cocoon.components.serializers.EncodingSerializer;
import org.apache.cocoon.components.serializers.encoding.XMLEncoder;
import org.apache.cocoon.components.serializers.util.DocType;
import org.apache.commons.lang.SystemUtils;
import org.xml.sax.SAXException;

public class XMLSerializer
extends EncodingSerializer {
    private static final XMLEncoder XML_ENCODER = new XMLEncoder();
    private static final char[] S_EOL = SystemUtils.LINE_SEPARATOR.toCharArray();
    private static final char[] S_DOCUMENT_1 = "<?xml version=\"1.0".toCharArray();
    private static final char[] S_DOCUMENT_2 = "\" encoding=\"".toCharArray();
    private static final char[] S_DOCUMENT_3 = "\"?>".toCharArray();
    private static final char[] S_ELEMENT_1 = "=\"".toCharArray();
    private static final char[] S_ELEMENT_2 = "</".toCharArray();
    private static final char[] S_ELEMENT_3 = " />".toCharArray();
    private static final char[] S_ELEMENT_4 = " xmlns".toCharArray();
    private static final char[] S_CDATA_1 = "<[CDATA[".toCharArray();
    private static final char[] S_CDATA_2 = "]]>".toCharArray();
    private static final char[] S_COMMENT_1 = "<!--".toCharArray();
    private static final char[] S_COMMENT_2 = "-->".toCharArray();
    private static final char[] S_PROCINSTR_1 = "<?".toCharArray();
    private static final char[] S_PROCINSTR_2 = "?>".toCharArray();
    private static final char C_LT = '<';
    private static final char C_GT = '>';
    private static final char C_SPACE = ' ';
    private static final char C_QUOTE = '\"';
    private static final char C_NSSEP = ':';
    private static final boolean DEBUG = false;
    private boolean hanging_element = false;
    private boolean processing_prolog = true;
    private boolean processing_dtd = false;
    private PrologWriter prolog = new PrologWriter();
    protected DocType doctype = null;

    public XMLSerializer() {
        super(XML_ENCODER);
    }

    protected XMLSerializer(XMLEncoder encoder) {
        super(encoder);
    }

    @Override
    public void recycle() {
        super.recycle();
        this.doctype = null;
        this.hanging_element = false;
        this.processing_prolog = true;
        this.processing_dtd = false;
        if (this.prolog != null) {
            this.prolog.reset();
        }
    }

    public String getMimeType() {
        if (this.charset == null) {
            return "text/xml";
        }
        return "text/xml; charset=" + this.charset.getName();
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.head();
    }

    @Override
    public void endDocument() throws SAXException {
        this.writeln();
        super.endDocument();
    }

    protected void head() throws SAXException {
        this.write(S_DOCUMENT_1);
        if (this.charset != null) {
            this.write(S_DOCUMENT_2);
            this.write(this.charset.getName());
        }
        this.write(S_DOCUMENT_3);
        this.writeln();
    }

    public void startDTD(String name, String public_id, String system_id) throws SAXException {
        this.processing_dtd = true;
        this.doctype = new DocType(name, public_id, system_id);
    }

    public void endDTD() throws SAXException {
        this.processing_dtd = false;
    }

    @Override
    public void body(String uri, String local, String qual) throws SAXException {
        this.processing_prolog = false;
        this.writeln();
        if (this.doctype != null) {
            String root_name = this.doctype.getName();
            if (!root_name.equals(qual)) {
                throw new SAXException("Root element name \"" + root_name + "\" declared by document type declaration differs " + "from actual root element name \"" + qual + "\"");
            }
            this.write(this.doctype.toString());
        }
        this.prolog.writeTo(this);
        this.writeln();
    }

    @Override
    public void startElementImpl(String uri, String local, String qual, String[][] namespaces, String[][] attributes) throws SAXException {
        int x;
        this.closeElement(false);
        this.write(60);
        this.write(qual);
        for (x = 0; x < namespaces.length; ++x) {
            this.write(S_ELEMENT_4);
            if (namespaces[x][0].length() > 0) {
                this.write(58);
                this.write(namespaces[x][0]);
            }
            this.write(S_ELEMENT_1);
            this.encode(namespaces[x][1]);
            this.write(34);
        }
        for (x = 0; x < attributes.length; ++x) {
            this.write(32);
            this.write(attributes[x][2]);
            this.write(S_ELEMENT_1);
            this.encode(attributes[x][3]);
            this.write(34);
        }
        this.hanging_element = true;
    }

    @Override
    public void endElementImpl(String uri, String local, String qual) throws SAXException {
        if (this.closeElement(true)) {
            return;
        }
        this.write(S_ELEMENT_2);
        this.write(qual);
        this.write(62);
    }

    protected boolean closeElement(boolean end_element) throws SAXException {
        if (!this.hanging_element) {
            return false;
        }
        if (end_element) {
            this.write(S_ELEMENT_3);
        } else {
            this.write(62);
        }
        this.hanging_element = false;
        return true;
    }

    public void startCDATA() throws SAXException {
        if (this.processing_prolog) {
            return;
        }
        this.closeElement(false);
        this.write(S_CDATA_1);
    }

    public void endCDATA() throws SAXException {
        if (this.processing_prolog) {
            return;
        }
        this.closeElement(false);
        this.write(S_CDATA_2);
    }

    @Override
    public void charactersImpl(char[] data, int start, int length) throws SAXException {
        if (this.processing_prolog) {
            return;
        }
        this.closeElement(false);
        this.encode(data, start, length);
    }

    public void ignorableWhitespace(char[] data, int start, int length) throws SAXException {
        this.charactersImpl(data, start, length);
    }

    public void comment(char[] data, int start, int length) throws SAXException {
        if (this.processing_dtd) {
            return;
        }
        if (this.processing_prolog) {
            this.prolog.write(S_COMMENT_1);
            this.prolog.write(data, start, length);
            this.prolog.write(S_COMMENT_2);
            this.prolog.write(S_EOL);
            return;
        }
        this.closeElement(false);
        this.write(S_COMMENT_1);
        this.write(data, start, length);
        this.write(S_COMMENT_2);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.processing_dtd) {
            return;
        }
        if (this.processing_prolog) {
            this.prolog.write(S_PROCINSTR_1);
            this.prolog.write(target);
            if (data != null) {
                this.prolog.write(32);
                this.prolog.write(data);
            }
            this.prolog.write(S_PROCINSTR_2);
            this.prolog.write(S_EOL);
            return;
        }
        this.closeElement(false);
        this.write(S_PROCINSTR_1);
        this.write(target);
        if (data != null) {
            this.write(32);
            this.write(data);
        }
        this.write(S_PROCINSTR_2);
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    private static final class PrologWriter
    extends CharArrayWriter {
        private PrologWriter() {
        }

        @Override
        public void write(char[] c) {
            this.write(c, 0, c.length);
        }

        @Override
        public void write(String str) {
            this.write(str, 0, str.length());
        }

        public void writeTo(XMLSerializer serializer) throws SAXException {
            serializer.write(this.buf, 0, this.count);
        }
    }
}

